package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Timeout,
  ProjectName,
  TagValue,
  Arn,
  DatasetName,
  JobName,
  EncryptionKeyArn,
  MaxCapacity,
  MaxRetries,
  TagKey
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class CreateRecipeJobRequest(
    datasetName: Optional[DatasetName] = Optional.Absent,
    encryptionKeyArn: Optional[EncryptionKeyArn] = Optional.Absent,
    encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode] =
      Optional.Absent,
    name: JobName,
    logSubscription: Optional[zio.aws.databrew.model.LogSubscription] =
      Optional.Absent,
    maxCapacity: Optional[MaxCapacity] = Optional.Absent,
    maxRetries: Optional[MaxRetries] = Optional.Absent,
    outputs: Optional[Iterable[zio.aws.databrew.model.Output]] =
      Optional.Absent,
    dataCatalogOutputs: Optional[
      Iterable[zio.aws.databrew.model.DataCatalogOutput]
    ] = Optional.Absent,
    databaseOutputs: Optional[Iterable[zio.aws.databrew.model.DatabaseOutput]] =
      Optional.Absent,
    projectName: Optional[ProjectName] = Optional.Absent,
    recipeReference: Optional[zio.aws.databrew.model.RecipeReference] =
      Optional.Absent,
    roleArn: Arn,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    timeout: Optional[Timeout] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest = {
    import CreateRecipeJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest
      .builder()
      .optionallyWith(
        datasetName.map(value => DatasetName.unwrap(value): java.lang.String)
      )(_.datasetName)
      .optionallyWith(
        encryptionKeyArn.map(value =>
          EncryptionKeyArn.unwrap(value): java.lang.String
        )
      )(_.encryptionKeyArn)
      .optionallyWith(encryptionMode.map(value => value.unwrap))(
        _.encryptionMode
      )
      .name(JobName.unwrap(name): java.lang.String)
      .optionallyWith(logSubscription.map(value => value.unwrap))(
        _.logSubscription
      )
      .optionallyWith(
        maxCapacity.map(value => MaxCapacity.unwrap(value): Integer)
      )(_.maxCapacity)
      .optionallyWith(
        maxRetries.map(value => MaxRetries.unwrap(value): Integer)
      )(_.maxRetries)
      .optionallyWith(
        outputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.outputs)
      .optionallyWith(
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dataCatalogOutputs)
      .optionallyWith(
        databaseOutputs.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.databaseOutputs)
      .optionallyWith(
        projectName.map(value => ProjectName.unwrap(value): java.lang.String)
      )(_.projectName)
      .optionallyWith(recipeReference.map(value => value.buildAwsValue()))(
        _.recipeReference
      )
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(timeout.map(value => Timeout.unwrap(value): Integer))(
        _.timeout
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRecipeJobRequest.ReadOnly =
    zio.aws.databrew.model.CreateRecipeJobRequest.wrap(buildAwsValue())
}
object CreateRecipeJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRecipeJobRequest =
      zio.aws.databrew.model.CreateRecipeJobRequest(
        datasetName.map(value => value),
        encryptionKeyArn.map(value => value),
        encryptionMode.map(value => value),
        name,
        logSubscription.map(value => value),
        maxCapacity.map(value => value),
        maxRetries.map(value => value),
        outputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dataCatalogOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        databaseOutputs.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        projectName.map(value => value),
        recipeReference.map(value => value.asEditable),
        roleArn,
        tags.map(value => value),
        timeout.map(value => value)
      )
    def datasetName: Optional[DatasetName]
    def encryptionKeyArn: Optional[EncryptionKeyArn]
    def encryptionMode: Optional[zio.aws.databrew.model.EncryptionMode]
    def name: JobName
    def logSubscription: Optional[zio.aws.databrew.model.LogSubscription]
    def maxCapacity: Optional[MaxCapacity]
    def maxRetries: Optional[MaxRetries]
    def outputs: Optional[List[zio.aws.databrew.model.Output.ReadOnly]]
    def dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]]
    def databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]]
    def projectName: Optional[ProjectName]
    def recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly]
    def roleArn: Arn
    def tags: Optional[Map[TagKey, TagValue]]
    def timeout: Optional[Timeout]
    def getDatasetName: ZIO[Any, AwsError, DatasetName] =
      AwsError.unwrapOptionField("datasetName", datasetName)
    def getEncryptionKeyArn: ZIO[Any, AwsError, EncryptionKeyArn] =
      AwsError.unwrapOptionField("encryptionKeyArn", encryptionKeyArn)
    def getEncryptionMode
        : ZIO[Any, AwsError, zio.aws.databrew.model.EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getLogSubscription
        : ZIO[Any, AwsError, zio.aws.databrew.model.LogSubscription] =
      AwsError.unwrapOptionField("logSubscription", logSubscription)
    def getMaxCapacity: ZIO[Any, AwsError, MaxCapacity] =
      AwsError.unwrapOptionField("maxCapacity", maxCapacity)
    def getMaxRetries: ZIO[Any, AwsError, MaxRetries] =
      AwsError.unwrapOptionField("maxRetries", maxRetries)
    def getOutputs
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Output.ReadOnly]] =
      AwsError.unwrapOptionField("outputs", outputs)
    def getDataCatalogOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DataCatalogOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("dataCatalogOutputs", dataCatalogOutputs)
    def getDatabaseOutputs: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.DatabaseOutput.ReadOnly
    ]] = AwsError.unwrapOptionField("databaseOutputs", databaseOutputs)
    def getProjectName: ZIO[Any, AwsError, ProjectName] =
      AwsError.unwrapOptionField("projectName", projectName)
    def getRecipeReference
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeReference.ReadOnly] =
      AwsError.unwrapOptionField("recipeReference", recipeReference)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTimeout: ZIO[Any, AwsError, Timeout] =
      AwsError.unwrapOptionField("timeout", timeout)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest
  ) extends zio.aws.databrew.model.CreateRecipeJobRequest.ReadOnly {
    override val datasetName: Optional[DatasetName] = zio.aws.core.internal
      .optionalFromNullable(impl.datasetName())
      .map(value => zio.aws.databrew.model.primitives.DatasetName(value))
    override val encryptionKeyArn: Optional[EncryptionKeyArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionKeyArn())
        .map(value => zio.aws.databrew.model.primitives.EncryptionKeyArn(value))
    override val encryptionMode
        : Optional[zio.aws.databrew.model.EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value => zio.aws.databrew.model.EncryptionMode.wrap(value))
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val logSubscription
        : Optional[zio.aws.databrew.model.LogSubscription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.logSubscription())
        .map(value => zio.aws.databrew.model.LogSubscription.wrap(value))
    override val maxCapacity: Optional[MaxCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.maxCapacity())
      .map(value => zio.aws.databrew.model.primitives.MaxCapacity(value))
    override val maxRetries: Optional[MaxRetries] = zio.aws.core.internal
      .optionalFromNullable(impl.maxRetries())
      .map(value => zio.aws.databrew.model.primitives.MaxRetries(value))
    override val outputs
        : Optional[List[zio.aws.databrew.model.Output.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Output.wrap(item)
          }.toList
        )
    override val dataCatalogOutputs
        : Optional[List[zio.aws.databrew.model.DataCatalogOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalogOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DataCatalogOutput.wrap(item)
          }.toList
        )
    override val databaseOutputs
        : Optional[List[zio.aws.databrew.model.DatabaseOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseOutputs())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.DatabaseOutput.wrap(item)
          }.toList
        )
    override val projectName: Optional[ProjectName] = zio.aws.core.internal
      .optionalFromNullable(impl.projectName())
      .map(value => zio.aws.databrew.model.primitives.ProjectName(value))
    override val recipeReference
        : Optional[zio.aws.databrew.model.RecipeReference.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipeReference())
        .map(value => zio.aws.databrew.model.RecipeReference.wrap(value))
    override val roleArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.roleArn())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val timeout: Optional[Timeout] = zio.aws.core.internal
      .optionalFromNullable(impl.timeout())
      .map(value => zio.aws.databrew.model.primitives.Timeout(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeJobRequest
  ): zio.aws.databrew.model.CreateRecipeJobRequest.ReadOnly = new Wrapper(impl)
}
