package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.DatabaseTableName
import scala.jdk.CollectionConverters._
final case class DatabaseTableOutputOptions(
    tempDirectory: Optional[zio.aws.databrew.model.S3Location] =
      Optional.Absent,
    tableName: DatabaseTableName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions = {
    import DatabaseTableOutputOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions
      .builder()
      .optionallyWith(tempDirectory.map(value => value.buildAwsValue()))(
        _.tempDirectory
      )
      .tableName(DatabaseTableName.unwrap(tableName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly =
    zio.aws.databrew.model.DatabaseTableOutputOptions.wrap(buildAwsValue())
}
object DatabaseTableOutputOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DatabaseTableOutputOptions =
      zio.aws.databrew.model.DatabaseTableOutputOptions(
        tempDirectory.map(value => value.asEditable),
        tableName
      )
    def tempDirectory: Optional[zio.aws.databrew.model.S3Location.ReadOnly]
    def tableName: DatabaseTableName
    def getTempDirectory
        : ZIO[Any, AwsError, zio.aws.databrew.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("tempDirectory", tempDirectory)
    def getTableName: ZIO[Any, Nothing, DatabaseTableName] =
      ZIO.succeed(tableName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions
  ) extends zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly {
    override val tempDirectory
        : Optional[zio.aws.databrew.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tempDirectory())
        .map(value => zio.aws.databrew.model.S3Location.wrap(value))
    override val tableName: DatabaseTableName =
      zio.aws.databrew.model.primitives.DatabaseTableName(impl.tableName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DatabaseTableOutputOptions
  ): zio.aws.databrew.model.DatabaseTableOutputOptions.ReadOnly = new Wrapper(
    impl
  )
}
