package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  Arn,
  DatasetName,
  CreatedBy,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class Dataset(
    accountId: Optional[AccountId] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createDate: Optional[Date] = Optional.Absent,
    name: DatasetName,
    format: Optional[zio.aws.databrew.model.InputFormat] = Optional.Absent,
    formatOptions: Optional[zio.aws.databrew.model.FormatOptions] =
      Optional.Absent,
    input: zio.aws.databrew.model.Input,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    lastModifiedBy: Optional[LastModifiedBy] = Optional.Absent,
    source: Optional[zio.aws.databrew.model.Source] = Optional.Absent,
    pathOptions: Optional[zio.aws.databrew.model.PathOptions] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.Dataset = {
    import Dataset.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Dataset
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .name(DatasetName.unwrap(name): java.lang.String)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(formatOptions.map(value => value.buildAwsValue()))(
        _.formatOptions
      )
      .input(input.buildAwsValue())
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(source.map(value => value.unwrap))(_.source)
      .optionallyWith(pathOptions.map(value => value.buildAwsValue()))(
        _.pathOptions
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Dataset.ReadOnly =
    zio.aws.databrew.model.Dataset.wrap(buildAwsValue())
}
object Dataset {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Dataset] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Dataset =
      zio.aws.databrew.model.Dataset(
        accountId.map(value => value),
        createdBy.map(value => value),
        createDate.map(value => value),
        name,
        format.map(value => value),
        formatOptions.map(value => value.asEditable),
        input.asEditable,
        lastModifiedDate.map(value => value),
        lastModifiedBy.map(value => value),
        source.map(value => value),
        pathOptions.map(value => value.asEditable),
        tags.map(value => value),
        resourceArn.map(value => value)
      )
    def accountId: Optional[AccountId]
    def createdBy: Optional[CreatedBy]
    def createDate: Optional[Date]
    def name: DatasetName
    def format: Optional[zio.aws.databrew.model.InputFormat]
    def formatOptions: Optional[zio.aws.databrew.model.FormatOptions.ReadOnly]
    def input: zio.aws.databrew.model.Input.ReadOnly
    def lastModifiedDate: Optional[Date]
    def lastModifiedBy: Optional[LastModifiedBy]
    def source: Optional[zio.aws.databrew.model.Source]
    def pathOptions: Optional[zio.aws.databrew.model.PathOptions.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def resourceArn: Optional[Arn]
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
    def getFormat: ZIO[Any, AwsError, zio.aws.databrew.model.InputFormat] =
      AwsError.unwrapOptionField("format", format)
    def getFormatOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.FormatOptions.ReadOnly] =
      AwsError.unwrapOptionField("formatOptions", formatOptions)
    def getInput: ZIO[Any, Nothing, zio.aws.databrew.model.Input.ReadOnly] =
      ZIO.succeed(input)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getSource: ZIO[Any, AwsError, zio.aws.databrew.model.Source] =
      AwsError.unwrapOptionField("source", source)
    def getPathOptions
        : ZIO[Any, AwsError, zio.aws.databrew.model.PathOptions.ReadOnly] =
      AwsError.unwrapOptionField("pathOptions", pathOptions)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Dataset
  ) extends zio.aws.databrew.model.Dataset.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
    override val format: Optional[zio.aws.databrew.model.InputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.databrew.model.InputFormat.wrap(value))
    override val formatOptions
        : Optional[zio.aws.databrew.model.FormatOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.formatOptions())
        .map(value => zio.aws.databrew.model.FormatOptions.wrap(value))
    override val input: zio.aws.databrew.model.Input.ReadOnly =
      zio.aws.databrew.model.Input.wrap(impl.input())
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val lastModifiedBy: Optional[LastModifiedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val source: Optional[zio.aws.databrew.model.Source] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.databrew.model.Source.wrap(value))
    override val pathOptions
        : Optional[zio.aws.databrew.model.PathOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.pathOptions())
        .map(value => zio.aws.databrew.model.PathOptions.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Dataset
  ): zio.aws.databrew.model.Dataset.ReadOnly = new Wrapper(impl)
}
