package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DeleteDatasetRequest(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest = {
    import DeleteDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteDatasetRequest.ReadOnly =
    zio.aws.databrew.model.DeleteDatasetRequest.wrap(buildAwsValue())
}
object DeleteDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteDatasetRequest =
      zio.aws.databrew.model.DeleteDatasetRequest(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest
  ) extends zio.aws.databrew.model.DeleteDatasetRequest.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteDatasetRequest
  ): zio.aws.databrew.model.DeleteDatasetRequest.ReadOnly = new Wrapper(impl)
}
