package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DeleteDatasetResponse(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse = {
    import DeleteDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly =
    zio.aws.databrew.model.DeleteDatasetResponse.wrap(buildAwsValue())
}
object DeleteDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteDatasetResponse =
      zio.aws.databrew.model.DeleteDatasetResponse(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse
  ) extends zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteDatasetResponse
  ): zio.aws.databrew.model.DeleteDatasetResponse.ReadOnly = new Wrapper(impl)
}
