package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class DescribeDatasetRequest(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest = {
    import DescribeDatasetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeDatasetRequest.ReadOnly =
    zio.aws.databrew.model.DescribeDatasetRequest.wrap(buildAwsValue())
}
object DescribeDatasetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeDatasetRequest =
      zio.aws.databrew.model.DescribeDatasetRequest(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest
  ) extends zio.aws.databrew.model.DescribeDatasetRequest.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeDatasetRequest
  ): zio.aws.databrew.model.DescribeDatasetRequest.ReadOnly = new Wrapper(impl)
}
