package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.ProjectName
import scala.jdk.CollectionConverters._
final case class DescribeProjectRequest(name: ProjectName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeProjectRequest = {
    import DescribeProjectRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeProjectRequest
      .builder()
      .name(ProjectName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeProjectRequest.ReadOnly =
    zio.aws.databrew.model.DescribeProjectRequest.wrap(buildAwsValue())
}
object DescribeProjectRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeProjectRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeProjectRequest =
      zio.aws.databrew.model.DescribeProjectRequest(name)
    def name: ProjectName
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeProjectRequest
  ) extends zio.aws.databrew.model.DescribeProjectRequest.ReadOnly {
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeProjectRequest
  ): zio.aws.databrew.model.DescribeProjectRequest.ReadOnly = new Wrapper(impl)
}
