package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait EncryptionMode {
  def unwrap: software.amazon.awssdk.services.databrew.model.EncryptionMode
}
object EncryptionMode {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.EncryptionMode
  ): zio.aws.databrew.model.EncryptionMode = value match {
    case software.amazon.awssdk.services.databrew.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.EncryptionMode.SSE_KMS =>
      val r = `SSE-KMS`
      r
    case software.amazon.awssdk.services.databrew.model.EncryptionMode.SSE_S3 =>
      val r = `SSE-S3`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databrew.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.EncryptionMode =
      software.amazon.awssdk.services.databrew.model.EncryptionMode.UNKNOWN_TO_SDK_VERSION
  }
  case object `SSE-KMS` extends zio.aws.databrew.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.EncryptionMode =
      software.amazon.awssdk.services.databrew.model.EncryptionMode.SSE_KMS
  }
  case object `SSE-S3` extends zio.aws.databrew.model.EncryptionMode {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.EncryptionMode =
      software.amazon.awssdk.services.databrew.model.EncryptionMode.SSE_S3
  }
}
