package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class Input(
    s3InputDefinition: Optional[zio.aws.databrew.model.S3Location] =
      Optional.Absent,
    dataCatalogInputDefinition: Optional[
      zio.aws.databrew.model.DataCatalogInputDefinition
    ] = Optional.Absent,
    databaseInputDefinition: Optional[
      zio.aws.databrew.model.DatabaseInputDefinition
    ] = Optional.Absent,
    metadata: Optional[zio.aws.databrew.model.Metadata] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.databrew.model.Input = {
    import Input.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Input
      .builder()
      .optionallyWith(s3InputDefinition.map(value => value.buildAwsValue()))(
        _.s3InputDefinition
      )
      .optionallyWith(
        dataCatalogInputDefinition.map(value => value.buildAwsValue())
      )(_.dataCatalogInputDefinition)
      .optionallyWith(
        databaseInputDefinition.map(value => value.buildAwsValue())
      )(_.databaseInputDefinition)
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Input.ReadOnly =
    zio.aws.databrew.model.Input.wrap(buildAwsValue())
}
object Input {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.databrew.model.Input] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Input = zio.aws.databrew.model.Input(
      s3InputDefinition.map(value => value.asEditable),
      dataCatalogInputDefinition.map(value => value.asEditable),
      databaseInputDefinition.map(value => value.asEditable),
      metadata.map(value => value.asEditable)
    )
    def s3InputDefinition: Optional[zio.aws.databrew.model.S3Location.ReadOnly]
    def dataCatalogInputDefinition
        : Optional[zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly]
    def databaseInputDefinition
        : Optional[zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly]
    def metadata: Optional[zio.aws.databrew.model.Metadata.ReadOnly]
    def getS3InputDefinition
        : ZIO[Any, AwsError, zio.aws.databrew.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3InputDefinition", s3InputDefinition)
    def getDataCatalogInputDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "dataCatalogInputDefinition",
      dataCatalogInputDefinition
    )
    def getDatabaseInputDefinition: ZIO[
      Any,
      AwsError,
      zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly
    ] = AwsError.unwrapOptionField(
      "databaseInputDefinition",
      databaseInputDefinition
    )
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.databrew.model.Metadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Input
  ) extends zio.aws.databrew.model.Input.ReadOnly {
    override val s3InputDefinition
        : Optional[zio.aws.databrew.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3InputDefinition())
        .map(value => zio.aws.databrew.model.S3Location.wrap(value))
    override val dataCatalogInputDefinition
        : Optional[zio.aws.databrew.model.DataCatalogInputDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataCatalogInputDefinition())
        .map(value =>
          zio.aws.databrew.model.DataCatalogInputDefinition.wrap(value)
        )
    override val databaseInputDefinition
        : Optional[zio.aws.databrew.model.DatabaseInputDefinition.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.databaseInputDefinition())
        .map(value =>
          zio.aws.databrew.model.DatabaseInputDefinition.wrap(value)
        )
    override val metadata: Optional[zio.aws.databrew.model.Metadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metadata())
        .map(value => zio.aws.databrew.model.Metadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Input
  ): zio.aws.databrew.model.Input.ReadOnly = new Wrapper(impl)
}
