package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{NextToken, MaxResults100, JobName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListJobRunsRequest(
    name: JobName,
    maxResults: Optional[MaxResults100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListJobRunsRequest = {
    import ListJobRunsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListJobRunsRequest
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListJobRunsRequest.ReadOnly =
    zio.aws.databrew.model.ListJobRunsRequest.wrap(buildAwsValue())
}
object ListJobRunsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListJobRunsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListJobRunsRequest =
      zio.aws.databrew.model.ListJobRunsRequest(
        name,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def name: JobName
    def maxResults: Optional[MaxResults100]
    def nextToken: Optional[NextToken]
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListJobRunsRequest
  ) extends zio.aws.databrew.model.ListJobRunsRequest.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
    override val maxResults: Optional[MaxResults100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListJobRunsRequest
  ): zio.aws.databrew.model.ListJobRunsRequest.ReadOnly = new Wrapper(impl)
}
