package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class ListJobsResponse(
    jobs: Iterable[zio.aws.databrew.model.Job],
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListJobsResponse = {
    import ListJobsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListJobsResponse
      .builder()
      .jobs(jobs.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListJobsResponse.ReadOnly =
    zio.aws.databrew.model.ListJobsResponse.wrap(buildAwsValue())
}
object ListJobsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListJobsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListJobsResponse =
      zio.aws.databrew.model.ListJobsResponse(
        jobs.map { item =>
          item.asEditable
        },
        nextToken.map(value => value)
      )
    def jobs: List[zio.aws.databrew.model.Job.ReadOnly]
    def nextToken: Optional[NextToken]
    def getJobs: ZIO[Any, Nothing, List[zio.aws.databrew.model.Job.ReadOnly]] =
      ZIO.succeed(jobs)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsResponse
  ) extends zio.aws.databrew.model.ListJobsResponse.ReadOnly {
    override val jobs: List[zio.aws.databrew.model.Job.ReadOnly] = impl
      .jobs()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Job.wrap(item)
      }
      .toList
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListJobsResponse
  ): zio.aws.databrew.model.ListJobsResponse.ReadOnly = new Wrapper(impl)
}
