package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait LogSubscription {
  def unwrap: software.amazon.awssdk.services.databrew.model.LogSubscription
}
object LogSubscription {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.LogSubscription
  ): zio.aws.databrew.model.LogSubscription = value match {
    case software.amazon.awssdk.services.databrew.model.LogSubscription.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.LogSubscription.ENABLE =>
      val r = ENABLE
      r
    case software.amazon.awssdk.services.databrew.model.LogSubscription.DISABLE =>
      val r = DISABLE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.databrew.model.LogSubscription {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.LogSubscription =
      software.amazon.awssdk.services.databrew.model.LogSubscription.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLE extends zio.aws.databrew.model.LogSubscription {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.LogSubscription =
      software.amazon.awssdk.services.databrew.model.LogSubscription.ENABLE
  }
  case object DISABLE extends zio.aws.databrew.model.LogSubscription {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.LogSubscription =
      software.amazon.awssdk.services.databrew.model.LogSubscription.DISABLE
  }
}
