package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  ClientSessionId,
  StepIndex,
  ProjectName,
  Preview
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SendProjectSessionActionRequest(
    preview: Optional[Preview] = Optional.Absent,
    name: ProjectName,
    recipeStep: Optional[zio.aws.databrew.model.RecipeStep] = Optional.Absent,
    stepIndex: Optional[StepIndex] = Optional.Absent,
    clientSessionId: Optional[ClientSessionId] = Optional.Absent,
    viewFrame: Optional[zio.aws.databrew.model.ViewFrame] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest = {
    import SendProjectSessionActionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
      .builder()
      .optionallyWith(
        preview.map(value => Preview.unwrap(value): java.lang.Boolean)
      )(_.preview)
      .name(ProjectName.unwrap(name): java.lang.String)
      .optionallyWith(recipeStep.map(value => value.buildAwsValue()))(
        _.recipeStep
      )
      .optionallyWith(stepIndex.map(value => StepIndex.unwrap(value): Integer))(
        _.stepIndex
      )
      .optionallyWith(
        clientSessionId.map(value =>
          ClientSessionId.unwrap(value): java.lang.String
        )
      )(_.clientSessionId)
      .optionallyWith(viewFrame.map(value => value.buildAwsValue()))(
        _.viewFrame
      )
      .build()
  }
  def asReadOnly
      : zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly =
    zio.aws.databrew.model.SendProjectSessionActionRequest.wrap(buildAwsValue())
}
object SendProjectSessionActionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.SendProjectSessionActionRequest =
      zio.aws.databrew.model.SendProjectSessionActionRequest(
        preview.map(value => value),
        name,
        recipeStep.map(value => value.asEditable),
        stepIndex.map(value => value),
        clientSessionId.map(value => value),
        viewFrame.map(value => value.asEditable)
      )
    def preview: Optional[Preview]
    def name: ProjectName
    def recipeStep: Optional[zio.aws.databrew.model.RecipeStep.ReadOnly]
    def stepIndex: Optional[StepIndex]
    def clientSessionId: Optional[ClientSessionId]
    def viewFrame: Optional[zio.aws.databrew.model.ViewFrame.ReadOnly]
    def getPreview: ZIO[Any, AwsError, Preview] =
      AwsError.unwrapOptionField("preview", preview)
    def getName: ZIO[Any, Nothing, ProjectName] = ZIO.succeed(name)
    def getRecipeStep
        : ZIO[Any, AwsError, zio.aws.databrew.model.RecipeStep.ReadOnly] =
      AwsError.unwrapOptionField("recipeStep", recipeStep)
    def getStepIndex: ZIO[Any, AwsError, StepIndex] =
      AwsError.unwrapOptionField("stepIndex", stepIndex)
    def getClientSessionId: ZIO[Any, AwsError, ClientSessionId] =
      AwsError.unwrapOptionField("clientSessionId", clientSessionId)
    def getViewFrame
        : ZIO[Any, AwsError, zio.aws.databrew.model.ViewFrame.ReadOnly] =
      AwsError.unwrapOptionField("viewFrame", viewFrame)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ) extends zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly {
    override val preview: Optional[Preview] = zio.aws.core.internal
      .optionalFromNullable(impl.preview())
      .map(value => zio.aws.databrew.model.primitives.Preview(value))
    override val name: ProjectName =
      zio.aws.databrew.model.primitives.ProjectName(impl.name())
    override val recipeStep
        : Optional[zio.aws.databrew.model.RecipeStep.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.recipeStep())
        .map(value => zio.aws.databrew.model.RecipeStep.wrap(value))
    override val stepIndex: Optional[StepIndex] = zio.aws.core.internal
      .optionalFromNullable(impl.stepIndex())
      .map(value => zio.aws.databrew.model.primitives.StepIndex(value))
    override val clientSessionId: Optional[ClientSessionId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.clientSessionId())
        .map(value => zio.aws.databrew.model.primitives.ClientSessionId(value))
    override val viewFrame
        : Optional[zio.aws.databrew.model.ViewFrame.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.viewFrame())
        .map(value => zio.aws.databrew.model.ViewFrame.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.SendProjectSessionActionRequest
  ): zio.aws.databrew.model.SendProjectSessionActionRequest.ReadOnly =
    new Wrapper(impl)
}
