package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait SessionStatus {
  def unwrap: software.amazon.awssdk.services.databrew.model.SessionStatus
}
object SessionStatus {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.SessionStatus
  ): zio.aws.databrew.model.SessionStatus = value match {
    case software.amazon.awssdk.services.databrew.model.SessionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.ASSIGNED =>
      val r = ASSIGNED
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.INITIALIZING =>
      val r = INITIALIZING
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.PROVISIONING =>
      val r = PROVISIONING
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.READY =>
      val r = READY
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.RECYCLING =>
      val r = RECYCLING
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.ROTATING =>
      val r = ROTATING
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.TERMINATING =>
      val r = TERMINATING
      r
    case software.amazon.awssdk.services.databrew.model.SessionStatus.UPDATING =>
      val r = UPDATING
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ASSIGNED extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.ASSIGNED
  }
  case object FAILED extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.FAILED
  }
  case object INITIALIZING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.INITIALIZING
  }
  case object PROVISIONING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.PROVISIONING
  }
  case object READY extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.READY
  }
  case object RECYCLING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.RECYCLING
  }
  case object ROTATING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.ROTATING
  }
  case object TERMINATED extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.TERMINATED
  }
  case object TERMINATING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.TERMINATING
  }
  case object UPDATING extends zio.aws.databrew.model.SessionStatus {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.SessionStatus =
      software.amazon.awssdk.services.databrew.model.SessionStatus.UPDATING
  }
}
