package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{
  ParameterValue,
  ParameterName,
  Statistic
}
import scala.jdk.CollectionConverters._
final case class StatisticOverride(
    statistic: Statistic,
    parameters: Map[ParameterName, ParameterValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StatisticOverride = {
    import StatisticOverride.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StatisticOverride
      .builder()
      .statistic(Statistic.unwrap(statistic): java.lang.String)
      .parameters(
        parameters
          .map({ case (key, value) =>
            (ParameterName.unwrap(key): java.lang.String) -> (ParameterValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StatisticOverride.ReadOnly =
    zio.aws.databrew.model.StatisticOverride.wrap(buildAwsValue())
}
object StatisticOverride {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StatisticOverride
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StatisticOverride =
      zio.aws.databrew.model.StatisticOverride(statistic, parameters)
    def statistic: Statistic
    def parameters: Map[ParameterName, ParameterValue]
    def getStatistic: ZIO[Any, Nothing, Statistic] = ZIO.succeed(statistic)
    def getParameters: ZIO[Any, Nothing, Map[ParameterName, ParameterValue]] =
      ZIO.succeed(parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StatisticOverride
  ) extends zio.aws.databrew.model.StatisticOverride.ReadOnly {
    override val statistic: Statistic =
      zio.aws.databrew.model.primitives.Statistic(impl.statistic())
    override val parameters: Map[ParameterName, ParameterValue] = impl
      .parameters()
      .asScala
      .map({ case (key, value) =>
        zio.aws.databrew.model.primitives.ParameterName(
          key
        ) -> zio.aws.databrew.model.primitives.ParameterValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StatisticOverride
  ): zio.aws.databrew.model.StatisticOverride.ReadOnly = new Wrapper(impl)
}
