package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.RecipeName
import scala.jdk.CollectionConverters._
final case class UpdateRecipeResponse(name: RecipeName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse = {
    import UpdateRecipeResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly =
    zio.aws.databrew.model.UpdateRecipeResponse.wrap(buildAwsValue())
}
object UpdateRecipeResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRecipeResponse =
      zio.aws.databrew.model.UpdateRecipeResponse(name)
    def name: RecipeName
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse
  ) extends zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRecipeResponse
  ): zio.aws.databrew.model.UpdateRecipeResponse.ReadOnly = new Wrapper(impl)
}
