package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.{RecipeVersion, RecipeName}
import scala.jdk.CollectionConverters._
final case class DeleteRecipeVersionResponse(
    name: RecipeName,
    recipeVersion: RecipeVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse = {
    import DeleteRecipeVersionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse
      .builder()
      .name(RecipeName.unwrap(name): java.lang.String)
      .recipeVersion(RecipeVersion.unwrap(recipeVersion): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly =
    zio.aws.databrew.model.DeleteRecipeVersionResponse.wrap(buildAwsValue())
}
object DeleteRecipeVersionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DeleteRecipeVersionResponse =
      zio.aws.databrew.model.DeleteRecipeVersionResponse(name, recipeVersion)
    def name: RecipeName
    def recipeVersion: RecipeVersion
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
    def getRecipeVersion: ZIO[Any, Nothing, RecipeVersion] =
      ZIO.succeed(recipeVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse
  ) extends zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly {
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
    override val recipeVersion: RecipeVersion =
      zio.aws.databrew.model.primitives.RecipeVersion(impl.recipeVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DeleteRecipeVersionResponse
  ): zio.aws.databrew.model.DeleteRecipeVersionResponse.ReadOnly = new Wrapper(
    impl
  )
}
