package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Date,
  LastModifiedBy,
  TagValue,
  RulesetDescription,
  Arn,
  RulesetName,
  CreatedBy,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class DescribeRulesetResponse(
    name: RulesetName,
    description: Optional[RulesetDescription] = Optional.Absent,
    targetArn: Optional[Arn] = Optional.Absent,
    rules: Optional[Iterable[zio.aws.databrew.model.Rule]] = Optional.Absent,
    createDate: Optional[Date] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    lastModifiedBy: Optional[LastModifiedBy] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    resourceArn: Optional[Arn] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse = {
    import DescribeRulesetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        targetArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.targetArn)
      .optionallyWith(
        rules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.rules)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly =
    zio.aws.databrew.model.DescribeRulesetResponse.wrap(buildAwsValue())
}
object DescribeRulesetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.DescribeRulesetResponse =
      zio.aws.databrew.model.DescribeRulesetResponse(
        name,
        description.map(value => value),
        targetArn.map(value => value),
        rules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createDate.map(value => value),
        createdBy.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        resourceArn.map(value => value),
        tags.map(value => value)
      )
    def name: RulesetName
    def description: Optional[RulesetDescription]
    def targetArn: Optional[Arn]
    def rules: Optional[List[zio.aws.databrew.model.Rule.ReadOnly]]
    def createDate: Optional[Date]
    def createdBy: Optional[CreatedBy]
    def lastModifiedBy: Optional[LastModifiedBy]
    def lastModifiedDate: Optional[Date]
    def resourceArn: Optional[Arn]
    def tags: Optional[Map[TagKey, TagValue]]
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTargetArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("targetArn", targetArn)
    def getRules
        : ZIO[Any, AwsError, List[zio.aws.databrew.model.Rule.ReadOnly]] =
      AwsError.unwrapOptionField("rules", rules)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ) extends zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val description: Optional[RulesetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.databrew.model.primitives.RulesetDescription(value)
        )
    override val targetArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.targetArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val rules: Optional[List[zio.aws.databrew.model.Rule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.Rule.wrap(item)
          }.toList
        )
    override val createDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val lastModifiedBy: Optional[LastModifiedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.DescribeRulesetResponse
  ): zio.aws.databrew.model.DescribeRulesetResponse.ReadOnly = new Wrapper(impl)
}
