package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.Statistic
import scala.jdk.CollectionConverters._
final case class StatisticsConfiguration(
    includedStatistics: Optional[Iterable[Statistic]] = Optional.Absent,
    overrides: Optional[Iterable[zio.aws.databrew.model.StatisticOverride]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.StatisticsConfiguration = {
    import StatisticsConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
      .builder()
      .optionallyWith(
        includedStatistics.map(value =>
          value.map { item =>
            Statistic.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedStatistics)
      .optionallyWith(
        overrides.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.overrides)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.StatisticsConfiguration.ReadOnly =
    zio.aws.databrew.model.StatisticsConfiguration.wrap(buildAwsValue())
}
object StatisticsConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.StatisticsConfiguration =
      zio.aws.databrew.model.StatisticsConfiguration(
        includedStatistics.map(value => value),
        overrides.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def includedStatistics: Optional[List[Statistic]]
    def overrides
        : Optional[List[zio.aws.databrew.model.StatisticOverride.ReadOnly]]
    def getIncludedStatistics: ZIO[Any, AwsError, List[Statistic]] =
      AwsError.unwrapOptionField("includedStatistics", includedStatistics)
    def getOverrides: ZIO[Any, AwsError, List[
      zio.aws.databrew.model.StatisticOverride.ReadOnly
    ]] = AwsError.unwrapOptionField("overrides", overrides)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ) extends zio.aws.databrew.model.StatisticsConfiguration.ReadOnly {
    override val includedStatistics: Optional[List[Statistic]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includedStatistics())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.primitives.Statistic(item)
          }.toList
        )
    override val overrides
        : Optional[List[zio.aws.databrew.model.StatisticOverride.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.overrides())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.databrew.model.StatisticOverride.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.StatisticsConfiguration
  ): zio.aws.databrew.model.StatisticsConfiguration.ReadOnly = new Wrapper(impl)
}
