package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait ThresholdType {
  def unwrap: software.amazon.awssdk.services.databrew.model.ThresholdType
}
object ThresholdType {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.ThresholdType
  ): zio.aws.databrew.model.ThresholdType = value match {
    case software.amazon.awssdk.services.databrew.model.ThresholdType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdType.GREATER_THAN_OR_EQUAL =>
      val r = GREATER_THAN_OR_EQUAL
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdType.LESS_THAN_OR_EQUAL =>
      val r = LESS_THAN_OR_EQUAL
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdType.GREATER_THAN =>
      val r = GREATER_THAN
      r
    case software.amazon.awssdk.services.databrew.model.ThresholdType.LESS_THAN =>
      val r = LESS_THAN
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdType =
      software.amazon.awssdk.services.databrew.model.ThresholdType.UNKNOWN_TO_SDK_VERSION
  }
  case object GREATER_THAN_OR_EQUAL
      extends zio.aws.databrew.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdType =
      software.amazon.awssdk.services.databrew.model.ThresholdType.GREATER_THAN_OR_EQUAL
  }
  case object LESS_THAN_OR_EQUAL extends zio.aws.databrew.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdType =
      software.amazon.awssdk.services.databrew.model.ThresholdType.LESS_THAN_OR_EQUAL
  }
  case object GREATER_THAN extends zio.aws.databrew.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdType =
      software.amazon.awssdk.services.databrew.model.ThresholdType.GREATER_THAN
  }
  case object LESS_THAN extends zio.aws.databrew.model.ThresholdType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ThresholdType =
      software.amazon.awssdk.services.databrew.model.ThresholdType.LESS_THAN
  }
}
