package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.DatasetName
import scala.jdk.CollectionConverters._
final case class UpdateDatasetResponse(name: DatasetName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse = {
    import UpdateDatasetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse
      .builder()
      .name(DatasetName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly =
    zio.aws.databrew.model.UpdateDatasetResponse.wrap(buildAwsValue())
}
object UpdateDatasetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateDatasetResponse =
      zio.aws.databrew.model.UpdateDatasetResponse(name)
    def name: DatasetName
    def getName: ZIO[Any, Nothing, DatasetName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse
  ) extends zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly {
    override val name: DatasetName =
      zio.aws.databrew.model.primitives.DatasetName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateDatasetResponse
  ): zio.aws.databrew.model.UpdateDatasetResponse.ReadOnly = new Wrapper(impl)
}
