package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.{RulesetDescription, RulesetName}
import scala.jdk.CollectionConverters._
final case class UpdateRulesetRequest(
    name: RulesetName,
    description: Optional[RulesetDescription] = Optional.Absent,
    rules: Iterable[zio.aws.databrew.model.Rule]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest = {
    import UpdateRulesetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest
      .builder()
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.UpdateRulesetRequest.ReadOnly =
    zio.aws.databrew.model.UpdateRulesetRequest.wrap(buildAwsValue())
}
object UpdateRulesetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.UpdateRulesetRequest =
      zio.aws.databrew.model.UpdateRulesetRequest(
        name,
        description.map(value => value),
        rules.map { item =>
          item.asEditable
        }
      )
    def name: RulesetName
    def description: Optional[RulesetDescription]
    def rules: List[zio.aws.databrew.model.Rule.ReadOnly]
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getRules
        : ZIO[Any, Nothing, List[zio.aws.databrew.model.Rule.ReadOnly]] =
      ZIO.succeed(rules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest
  ) extends zio.aws.databrew.model.UpdateRulesetRequest.ReadOnly {
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val description: Optional[RulesetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.databrew.model.primitives.RulesetDescription(value)
        )
    override val rules: List[zio.aws.databrew.model.Rule.ReadOnly] = impl
      .rules()
      .asScala
      .map { item =>
        zio.aws.databrew.model.Rule.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.UpdateRulesetRequest
  ): zio.aws.databrew.model.UpdateRulesetRequest.ReadOnly = new Wrapper(impl)
}
