package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.databrew.model.primitives.JobName
import scala.jdk.CollectionConverters._
final case class CreateRecipeJobResponse(name: JobName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse = {
    import CreateRecipeJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse
      .builder()
      .name(JobName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly =
    zio.aws.databrew.model.CreateRecipeJobResponse.wrap(buildAwsValue())
}
object CreateRecipeJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.CreateRecipeJobResponse =
      zio.aws.databrew.model.CreateRecipeJobResponse(name)
    def name: JobName
    def getName: ZIO[Any, Nothing, JobName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse
  ) extends zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly {
    override val name: JobName =
      zio.aws.databrew.model.primitives.JobName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.CreateRecipeJobResponse
  ): zio.aws.databrew.model.CreateRecipeJobResponse.ReadOnly = new Wrapper(impl)
}
