package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{RecipeName, NextToken, MaxResults100}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRecipeVersionsRequest(
    maxResults: Optional[MaxResults100] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    name: RecipeName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest = {
    import ListRecipeVersionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults100.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .name(RecipeName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly =
    zio.aws.databrew.model.ListRecipeVersionsRequest.wrap(buildAwsValue())
}
object ListRecipeVersionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.ListRecipeVersionsRequest =
      zio.aws.databrew.model.ListRecipeVersionsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        name
      )
    def maxResults: Optional[MaxResults100]
    def nextToken: Optional[NextToken]
    def name: RecipeName
    def getMaxResults: ZIO[Any, AwsError, MaxResults100] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getName: ZIO[Any, Nothing, RecipeName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ) extends zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly {
    override val maxResults: Optional[MaxResults100] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.databrew.model.primitives.MaxResults100(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.databrew.model.primitives.NextToken(value))
    override val name: RecipeName =
      zio.aws.databrew.model.primitives.RecipeName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.ListRecipeVersionsRequest
  ): zio.aws.databrew.model.ListRecipeVersionsRequest.ReadOnly = new Wrapper(
    impl
  )
}
