package zio.aws.databrew.model
import scala.jdk.CollectionConverters._
sealed trait ParameterType {
  def unwrap: software.amazon.awssdk.services.databrew.model.ParameterType
}
object ParameterType {
  def wrap(
      value: software.amazon.awssdk.services.databrew.model.ParameterType
  ): zio.aws.databrew.model.ParameterType = value match {
    case software.amazon.awssdk.services.databrew.model.ParameterType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.databrew.model.ParameterType.DATETIME =>
      val r = Datetime
      r
    case software.amazon.awssdk.services.databrew.model.ParameterType.NUMBER =>
      val r = Number
      r
    case software.amazon.awssdk.services.databrew.model.ParameterType.STRING =>
      val r = String
      r
  }
  case object unknownToSdkVersion extends zio.aws.databrew.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ParameterType =
      software.amazon.awssdk.services.databrew.model.ParameterType.UNKNOWN_TO_SDK_VERSION
  }
  case object Datetime extends zio.aws.databrew.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ParameterType =
      software.amazon.awssdk.services.databrew.model.ParameterType.DATETIME
  }
  case object Number extends zio.aws.databrew.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ParameterType =
      software.amazon.awssdk.services.databrew.model.ParameterType.NUMBER
  }
  case object String extends zio.aws.databrew.model.ParameterType {
    override def unwrap
        : software.amazon.awssdk.services.databrew.model.ParameterType =
      software.amazon.awssdk.services.databrew.model.ParameterType.STRING
  }
}
