package zio.aws.databrew.model
import zio.aws.databrew.model.primitives.{
  Date,
  AccountId,
  LastModifiedBy,
  TagValue,
  RulesetDescription,
  Arn,
  RulesetName,
  CreatedBy,
  RuleCount,
  TagKey
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class RulesetItem(
    accountId: Optional[AccountId] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    createDate: Optional[Date] = Optional.Absent,
    description: Optional[RulesetDescription] = Optional.Absent,
    lastModifiedBy: Optional[LastModifiedBy] = Optional.Absent,
    lastModifiedDate: Optional[Date] = Optional.Absent,
    name: RulesetName,
    resourceArn: Optional[Arn] = Optional.Absent,
    ruleCount: Optional[RuleCount] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    targetArn: Arn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.RulesetItem = {
    import RulesetItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.RulesetItem
      .builder()
      .optionallyWith(
        accountId.map(value => AccountId.unwrap(value): java.lang.String)
      )(_.accountId)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(createDate.map(value => Date.unwrap(value): Instant))(
        _.createDate
      )
      .optionallyWith(
        description.map(value =>
          RulesetDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        lastModifiedBy.map(value =>
          LastModifiedBy.unwrap(value): java.lang.String
        )
      )(_.lastModifiedBy)
      .optionallyWith(
        lastModifiedDate.map(value => Date.unwrap(value): Instant)
      )(_.lastModifiedDate)
      .name(RulesetName.unwrap(name): java.lang.String)
      .optionallyWith(
        resourceArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.resourceArn)
      .optionallyWith(ruleCount.map(value => RuleCount.unwrap(value): Integer))(
        _.ruleCount
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .targetArn(Arn.unwrap(targetArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.RulesetItem.ReadOnly =
    zio.aws.databrew.model.RulesetItem.wrap(buildAwsValue())
}
object RulesetItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.RulesetItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.RulesetItem =
      zio.aws.databrew.model.RulesetItem(
        accountId.map(value => value),
        createdBy.map(value => value),
        createDate.map(value => value),
        description.map(value => value),
        lastModifiedBy.map(value => value),
        lastModifiedDate.map(value => value),
        name,
        resourceArn.map(value => value),
        ruleCount.map(value => value),
        tags.map(value => value),
        targetArn
      )
    def accountId: Optional[AccountId]
    def createdBy: Optional[CreatedBy]
    def createDate: Optional[Date]
    def description: Optional[RulesetDescription]
    def lastModifiedBy: Optional[LastModifiedBy]
    def lastModifiedDate: Optional[Date]
    def name: RulesetName
    def resourceArn: Optional[Arn]
    def ruleCount: Optional[RuleCount]
    def tags: Optional[Map[TagKey, TagValue]]
    def targetArn: Arn
    def getAccountId: ZIO[Any, AwsError, AccountId] =
      AwsError.unwrapOptionField("accountId", accountId)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getCreateDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDescription: ZIO[Any, AwsError, RulesetDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLastModifiedBy: ZIO[Any, AwsError, LastModifiedBy] =
      AwsError.unwrapOptionField("lastModifiedBy", lastModifiedBy)
    def getLastModifiedDate: ZIO[Any, AwsError, Date] =
      AwsError.unwrapOptionField("lastModifiedDate", lastModifiedDate)
    def getName: ZIO[Any, Nothing, RulesetName] = ZIO.succeed(name)
    def getResourceArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getRuleCount: ZIO[Any, AwsError, RuleCount] =
      AwsError.unwrapOptionField("ruleCount", ruleCount)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTargetArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(targetArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.RulesetItem
  ) extends zio.aws.databrew.model.RulesetItem.ReadOnly {
    override val accountId: Optional[AccountId] = zio.aws.core.internal
      .optionalFromNullable(impl.accountId())
      .map(value => zio.aws.databrew.model.primitives.AccountId(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.databrew.model.primitives.CreatedBy(value))
    override val createDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val description: Optional[RulesetDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.databrew.model.primitives.RulesetDescription(value)
        )
    override val lastModifiedBy: Optional[LastModifiedBy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModifiedBy())
        .map(value => zio.aws.databrew.model.primitives.LastModifiedBy(value))
    override val lastModifiedDate: Optional[Date] = zio.aws.core.internal
      .optionalFromNullable(impl.lastModifiedDate())
      .map(value => zio.aws.databrew.model.primitives.Date(value))
    override val name: RulesetName =
      zio.aws.databrew.model.primitives.RulesetName(impl.name())
    override val resourceArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceArn())
      .map(value => zio.aws.databrew.model.primitives.Arn(value))
    override val ruleCount: Optional[RuleCount] = zio.aws.core.internal
      .optionalFromNullable(impl.ruleCount())
      .map(value => zio.aws.databrew.model.primitives.RuleCount(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.databrew.model.primitives
              .TagKey(key) -> zio.aws.databrew.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val targetArn: Arn =
      zio.aws.databrew.model.primitives.Arn(impl.targetArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.RulesetItem
  ): zio.aws.databrew.model.RulesetItem.ReadOnly = new Wrapper(impl)
}
