package zio.aws.databrew.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.databrew.model.primitives.ThresholdValue
import scala.jdk.CollectionConverters._
final case class Threshold(
    value: ThresholdValue,
    `type`: Optional[zio.aws.databrew.model.ThresholdType] = Optional.Absent,
    unit: Optional[zio.aws.databrew.model.ThresholdUnit] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.databrew.model.Threshold = {
    import Threshold.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.databrew.model.Threshold
      .builder()
      .value(ThresholdValue.unwrap(value): java.lang.Double)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .build()
  }
  def asReadOnly: zio.aws.databrew.model.Threshold.ReadOnly =
    zio.aws.databrew.model.Threshold.wrap(buildAwsValue())
}
object Threshold {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.databrew.model.Threshold
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.databrew.model.Threshold = zio.aws.databrew.model
      .Threshold(value, `type`.map(value => value), unit.map(value => value))
    def value: ThresholdValue
    def `type`: Optional[zio.aws.databrew.model.ThresholdType]
    def unit: Optional[zio.aws.databrew.model.ThresholdUnit]
    def getValue: ZIO[Any, Nothing, ThresholdValue] = ZIO.succeed(value)
    def getType: ZIO[Any, AwsError, zio.aws.databrew.model.ThresholdType] =
      AwsError.unwrapOptionField("type", `type`)
    def getUnit: ZIO[Any, AwsError, zio.aws.databrew.model.ThresholdUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.databrew.model.Threshold
  ) extends zio.aws.databrew.model.Threshold.ReadOnly {
    override val value: ThresholdValue =
      zio.aws.databrew.model.primitives.ThresholdValue(impl.value())
    override val `type`: Optional[zio.aws.databrew.model.ThresholdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.databrew.model.ThresholdType.wrap(value))
    override val unit: Optional[zio.aws.databrew.model.ThresholdUnit] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unit())
        .map(value => zio.aws.databrew.model.ThresholdUnit.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.databrew.model.Threshold
  ): zio.aws.databrew.model.Threshold.ReadOnly = new Wrapper(impl)
}
