package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait AzureBlobAuthenticationType {
  def unwrap: software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType
}
object AzureBlobAuthenticationType {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType
  ): zio.aws.datasync.model.AzureBlobAuthenticationType = value match {
    case software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType.SAS =>
      val r = SAS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.AzureBlobAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType =
      software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType.UNKNOWN_TO_SDK_VERSION
  }
  case object SAS extends zio.aws.datasync.model.AzureBlobAuthenticationType {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType =
      software.amazon.awssdk.services.datasync.model.AzureBlobAuthenticationType.SAS
  }
}
