package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationFsxOntapResponse(
    locationArn: Optional[LocationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse = {
    import CreateLocationFsxOntapResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationFsxOntapResponse.wrap(buildAwsValue())
}
object CreateLocationFsxOntapResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationFsxOntapResponse =
      zio.aws.datasync.model
        .CreateLocationFsxOntapResponse(locationArn.map(value => value))
    def locationArn: Optional[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse
  ) extends zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationFsxOntapResponse
  ): zio.aws.datasync.model.CreateLocationFsxOntapResponse.ReadOnly =
    new Wrapper(impl)
}
