package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationNfsResponse(
    locationArn: Optional[LocationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse = {
    import CreateLocationNfsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse
      .builder()
      .optionallyWith(
        locationArn.map(value => LocationArn.unwrap(value): java.lang.String)
      )(_.locationArn)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly =
    zio.aws.datasync.model.CreateLocationNfsResponse.wrap(buildAwsValue())
}
object CreateLocationNfsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationNfsResponse =
      zio.aws.datasync.model
        .CreateLocationNfsResponse(locationArn.map(value => value))
    def locationArn: Optional[LocationArn]
    def getLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("locationArn", locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse
  ) extends zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly {
    override val locationArn: Optional[LocationArn] = zio.aws.core.internal
      .optionalFromNullable(impl.locationArn())
      .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationNfsResponse
  ): zio.aws.datasync.model.CreateLocationNfsResponse.ReadOnly = new Wrapper(
    impl
  )
}
