package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{
  SmbUser,
  SmbSubdirectory,
  SmbPassword,
  KerberosKeytabFile,
  SmbDomain,
  KerberosPrincipal,
  KerberosKrb5ConfFile,
  ServerIpAddress,
  ServerHostname,
  AgentArn
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateLocationSmbRequest(
    subdirectory: SmbSubdirectory,
    serverHostname: ServerHostname,
    user: Optional[SmbUser] = Optional.Absent,
    domain: Optional[SmbDomain] = Optional.Absent,
    password: Optional[SmbPassword] = Optional.Absent,
    agentArns: Iterable[AgentArn],
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.datasync.model.TagListEntry]] =
      Optional.Absent,
    authenticationType: Optional[zio.aws.datasync.model.SmbAuthenticationType] =
      Optional.Absent,
    dnsIpAddresses: Optional[Iterable[ServerIpAddress]] = Optional.Absent,
    kerberosPrincipal: Optional[KerberosPrincipal] = Optional.Absent,
    kerberosKeytab: Optional[KerberosKeytabFile] = Optional.Absent,
    kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest = {
    import CreateLocationSmbRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
      .builder()
      .subdirectory(SmbSubdirectory.unwrap(subdirectory): java.lang.String)
      .serverHostname(ServerHostname.unwrap(serverHostname): java.lang.String)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .optionallyWith(
        domain.map(value => SmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        password.map(value => SmbPassword.unwrap(value): java.lang.String)
      )(_.password)
      .agentArns(agentArns.map { item =>
        AgentArn.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(authenticationType.map(value => value.unwrap))(
        _.authenticationType
      )
      .optionallyWith(
        dnsIpAddresses.map(value =>
          value.map { item =>
            ServerIpAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dnsIpAddresses)
      .optionallyWith(
        kerberosPrincipal.map(value =>
          KerberosPrincipal.unwrap(value): java.lang.String
        )
      )(_.kerberosPrincipal)
      .optionallyWith(
        kerberosKeytab.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKeytab)
      .optionallyWith(
        kerberosKrb5Conf.map(value =>
          software.amazon.awssdk.core.SdkBytes
            .fromByteArrayUnsafe(value.toArray[Byte])
        )
      )(_.kerberosKrb5Conf)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly =
    zio.aws.datasync.model.CreateLocationSmbRequest.wrap(buildAwsValue())
}
object CreateLocationSmbRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.CreateLocationSmbRequest =
      zio.aws.datasync.model.CreateLocationSmbRequest(
        subdirectory,
        serverHostname,
        user.map(value => value),
        domain.map(value => value),
        password.map(value => value),
        agentArns,
        mountOptions.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        authenticationType.map(value => value),
        dnsIpAddresses.map(value => value),
        kerberosPrincipal.map(value => value),
        kerberosKeytab.map(value => value),
        kerberosKrb5Conf.map(value => value)
      )
    def subdirectory: SmbSubdirectory
    def serverHostname: ServerHostname
    def user: Optional[SmbUser]
    def domain: Optional[SmbDomain]
    def password: Optional[SmbPassword]
    def agentArns: List[AgentArn]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def tags: Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]]
    def authenticationType
        : Optional[zio.aws.datasync.model.SmbAuthenticationType]
    def dnsIpAddresses: Optional[List[ServerIpAddress]]
    def kerberosPrincipal: Optional[KerberosPrincipal]
    def kerberosKeytab: Optional[KerberosKeytabFile]
    def kerberosKrb5Conf: Optional[KerberosKrb5ConfFile]
    def getSubdirectory: ZIO[Any, Nothing, SmbSubdirectory] =
      ZIO.succeed(subdirectory)
    def getServerHostname: ZIO[Any, Nothing, ServerHostname] =
      ZIO.succeed(serverHostname)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
    def getDomain: ZIO[Any, AwsError, SmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getPassword: ZIO[Any, AwsError, SmbPassword] =
      AwsError.unwrapOptionField("password", password)
    def getAgentArns: ZIO[Any, Nothing, List[AgentArn]] = ZIO.succeed(agentArns)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getTags: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.TagListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("tags", tags)
    def getAuthenticationType
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbAuthenticationType] =
      AwsError.unwrapOptionField("authenticationType", authenticationType)
    def getDnsIpAddresses: ZIO[Any, AwsError, List[ServerIpAddress]] =
      AwsError.unwrapOptionField("dnsIpAddresses", dnsIpAddresses)
    def getKerberosPrincipal: ZIO[Any, AwsError, KerberosPrincipal] =
      AwsError.unwrapOptionField("kerberosPrincipal", kerberosPrincipal)
    def getKerberosKeytab: ZIO[Any, AwsError, KerberosKeytabFile] =
      AwsError.unwrapOptionField("kerberosKeytab", kerberosKeytab)
    def getKerberosKrb5Conf: ZIO[Any, AwsError, KerberosKrb5ConfFile] =
      AwsError.unwrapOptionField("kerberosKrb5Conf", kerberosKrb5Conf)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ) extends zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly {
    override val subdirectory: SmbSubdirectory =
      zio.aws.datasync.model.primitives.SmbSubdirectory(impl.subdirectory())
    override val serverHostname: ServerHostname =
      zio.aws.datasync.model.primitives.ServerHostname(impl.serverHostname())
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
    override val domain: Optional[SmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.SmbDomain(value))
    override val password: Optional[SmbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.datasync.model.primitives.SmbPassword(value))
    override val agentArns: List[AgentArn] = impl
      .agentArns()
      .asScala
      .map { item =>
        zio.aws.datasync.model.primitives.AgentArn(item)
      }
      .toList
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val tags
        : Optional[List[zio.aws.datasync.model.TagListEntry.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TagListEntry.wrap(item)
          }.toList
        )
    override val authenticationType
        : Optional[zio.aws.datasync.model.SmbAuthenticationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationType())
        .map(value => zio.aws.datasync.model.SmbAuthenticationType.wrap(value))
    override val dnsIpAddresses: Optional[List[ServerIpAddress]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dnsIpAddresses())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.primitives.ServerIpAddress(item)
          }.toList
        )
    override val kerberosPrincipal: Optional[KerberosPrincipal] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosPrincipal())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosPrincipal(value)
        )
    override val kerberosKeytab: Optional[KerberosKeytabFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKeytab())
        .map(value =>
          zio.aws.datasync.model.primitives
            .KerberosKeytabFile(zio.Chunk.fromArray(value.asByteArrayUnsafe()))
        )
    override val kerberosKrb5Conf: Optional[KerberosKrb5ConfFile] =
      zio.aws.core.internal
        .optionalFromNullable(impl.kerberosKrb5Conf())
        .map(value =>
          zio.aws.datasync.model.primitives.KerberosKrb5ConfFile(
            zio.Chunk.fromArray(value.asByteArrayUnsafe())
          )
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.CreateLocationSmbRequest
  ): zio.aws.datasync.model.CreateLocationSmbRequest.ReadOnly = new Wrapper(
    impl
  )
}
