package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.LocationArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeLocationFsxWindowsRequest(locationArn: LocationArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest = {
    import DescribeLocationFsxWindowsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest
      .builder()
      .locationArn(LocationArn.unwrap(locationArn): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeLocationFsxWindowsRequest.ReadOnly =
    zio.aws.datasync.model.DescribeLocationFsxWindowsRequest
      .wrap(buildAwsValue())
}
object DescribeLocationFsxWindowsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeLocationFsxWindowsRequest =
      zio.aws.datasync.model.DescribeLocationFsxWindowsRequest(locationArn)
    def locationArn: LocationArn
    def getLocationArn: ZIO[Any, Nothing, LocationArn] =
      ZIO.succeed(locationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest
  ) extends zio.aws.datasync.model.DescribeLocationFsxWindowsRequest.ReadOnly {
    override val locationArn: LocationArn =
      zio.aws.datasync.model.primitives.LocationArn(impl.locationArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeLocationFsxWindowsRequest
  ): zio.aws.datasync.model.DescribeLocationFsxWindowsRequest.ReadOnly =
    new Wrapper(impl)
}
