package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.StorageSystemArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeStorageSystemRequest(
    storageSystemArn: StorageSystemArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest = {
    import DescribeStorageSystemRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest
      .builder()
      .storageSystemArn(
        StorageSystemArn.unwrap(storageSystemArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeStorageSystemRequest.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemRequest.wrap(buildAwsValue())
}
object DescribeStorageSystemRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeStorageSystemRequest =
      zio.aws.datasync.model.DescribeStorageSystemRequest(storageSystemArn)
    def storageSystemArn: StorageSystemArn
    def getStorageSystemArn: ZIO[Any, Nothing, StorageSystemArn] =
      ZIO.succeed(storageSystemArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest
  ) extends zio.aws.datasync.model.DescribeStorageSystemRequest.ReadOnly {
    override val storageSystemArn: StorageSystemArn =
      zio.aws.datasync.model.primitives
        .StorageSystemArn(impl.storageSystemArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemRequest
  ): zio.aws.datasync.model.DescribeStorageSystemRequest.ReadOnly = new Wrapper(
    impl
  )
}
