package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  PtolemyString,
  DiscoveryJobArn,
  DiscoveryMaxResults,
  DiscoveryNextToken,
  ResourceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeStorageSystemResourcesRequest(
    discoveryJobArn: DiscoveryJobArn,
    resourceType: zio.aws.datasync.model.DiscoveryResourceType,
    resourceIds: Optional[Iterable[ResourceId]] = Optional.Absent,
    filter: Optional[
      Map[zio.aws.datasync.model.DiscoveryResourceFilter, Iterable[
        PtolemyString
      ]]
    ] = Optional.Absent,
    maxResults: Optional[DiscoveryMaxResults] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest = {
    import DescribeStorageSystemResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest
      .builder()
      .discoveryJobArn(
        DiscoveryJobArn.unwrap(discoveryJobArn): java.lang.String
      )
      .resourceType(resourceType.unwrap)
      .optionallyWith(
        resourceIds.map(value =>
          value.map { item =>
            ResourceId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.resourceIds)
      .optionallyWith(
        filter.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> value.map { item =>
                PtolemyString.unwrap(item): java.lang.String
              }.asJavaCollection
            })
            .asJava
        )
      )(_.filterWithStrings)
      .optionallyWith(
        maxResults.map(value => DiscoveryMaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeStorageSystemResourcesRequest.ReadOnly =
    zio.aws.datasync.model.DescribeStorageSystemResourcesRequest
      .wrap(buildAwsValue())
}
object DescribeStorageSystemResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.datasync.model.DescribeStorageSystemResourcesRequest =
      zio.aws.datasync.model.DescribeStorageSystemResourcesRequest(
        discoveryJobArn,
        resourceType,
        resourceIds.map(value => value),
        filter.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def discoveryJobArn: DiscoveryJobArn
    def resourceType: zio.aws.datasync.model.DiscoveryResourceType
    def resourceIds: Optional[List[ResourceId]]
    def filter: Optional[
      Map[zio.aws.datasync.model.DiscoveryResourceFilter, List[PtolemyString]]
    ]
    def maxResults: Optional[DiscoveryMaxResults]
    def nextToken: Optional[DiscoveryNextToken]
    def getDiscoveryJobArn: ZIO[Any, Nothing, DiscoveryJobArn] =
      ZIO.succeed(discoveryJobArn)
    def getResourceType
        : ZIO[Any, Nothing, zio.aws.datasync.model.DiscoveryResourceType] =
      ZIO.succeed(resourceType)
    def getResourceIds: ZIO[Any, AwsError, List[ResourceId]] =
      AwsError.unwrapOptionField("resourceIds", resourceIds)
    def getFilter: ZIO[Any, AwsError, Map[
      zio.aws.datasync.model.DiscoveryResourceFilter,
      List[PtolemyString]
    ]] = AwsError.unwrapOptionField("filter", filter)
    def getMaxResults: ZIO[Any, AwsError, DiscoveryMaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest
  ) extends zio.aws.datasync.model.DescribeStorageSystemResourcesRequest.ReadOnly {
    override val discoveryJobArn: DiscoveryJobArn =
      zio.aws.datasync.model.primitives.DiscoveryJobArn(impl.discoveryJobArn())
    override val resourceType: zio.aws.datasync.model.DiscoveryResourceType =
      zio.aws.datasync.model.DiscoveryResourceType.wrap(impl.resourceType())
    override val resourceIds: Optional[List[ResourceId]] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.ResourceId(item)
        }.toList
      )
    override val filter: Optional[
      Map[zio.aws.datasync.model.DiscoveryResourceFilter, List[PtolemyString]]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filter())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.datasync.model.DiscoveryResourceFilter
              .wrap(key) -> value.asScala.map { item =>
              zio.aws.datasync.model.primitives.PtolemyString(item)
            }.toList
          })
          .toMap
      )
    override val maxResults: Optional[DiscoveryMaxResults] =
      zio.aws.core.internal
        .optionalFromNullable(impl.maxResults())
        .map(value =>
          zio.aws.datasync.model.primitives.DiscoveryMaxResults(value)
        )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeStorageSystemResourcesRequest
  ): zio.aws.datasync.model.DescribeStorageSystemResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
