package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.TaskExecutionArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DescribeTaskExecutionRequest(
    taskExecutionArn: TaskExecutionArn
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest = {
    import DescribeTaskExecutionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest
      .builder()
      .taskExecutionArn(
        TaskExecutionArn.unwrap(taskExecutionArn): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeTaskExecutionRequest.ReadOnly =
    zio.aws.datasync.model.DescribeTaskExecutionRequest.wrap(buildAwsValue())
}
object DescribeTaskExecutionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskExecutionRequest =
      zio.aws.datasync.model.DescribeTaskExecutionRequest(taskExecutionArn)
    def taskExecutionArn: TaskExecutionArn
    def getTaskExecutionArn: ZIO[Any, Nothing, TaskExecutionArn] =
      ZIO.succeed(taskExecutionArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest
  ) extends zio.aws.datasync.model.DescribeTaskExecutionRequest.ReadOnly {
    override val taskExecutionArn: TaskExecutionArn =
      zio.aws.datasync.model.primitives
        .TaskExecutionArn(impl.taskExecutionArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionRequest
  ): zio.aws.datasync.model.DescribeTaskExecutionRequest.ReadOnly = new Wrapper(
    impl
  )
}
