package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{Time, TaskExecutionArn}
import scala.jdk.CollectionConverters._
final case class DescribeTaskExecutionResponse(
    taskExecutionArn: Optional[TaskExecutionArn] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.TaskExecutionStatus] =
      Optional.Absent,
    options: Optional[zio.aws.datasync.model.Options] = Optional.Absent,
    excludes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    includes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    manifestConfig: Optional[zio.aws.datasync.model.ManifestConfig] =
      Optional.Absent,
    startTime: Optional[Time] = Optional.Absent,
    estimatedFilesToTransfer: Optional[Long] = Optional.Absent,
    estimatedBytesToTransfer: Optional[Long] = Optional.Absent,
    filesTransferred: Optional[Long] = Optional.Absent,
    bytesWritten: Optional[Long] = Optional.Absent,
    bytesTransferred: Optional[Long] = Optional.Absent,
    bytesCompressed: Optional[Long] = Optional.Absent,
    result: Optional[zio.aws.datasync.model.TaskExecutionResultDetail] =
      Optional.Absent,
    taskReportConfig: Optional[zio.aws.datasync.model.TaskReportConfig] =
      Optional.Absent,
    filesDeleted: Optional[Long] = Optional.Absent,
    filesSkipped: Optional[Long] = Optional.Absent,
    filesVerified: Optional[Long] = Optional.Absent,
    reportResult: Optional[zio.aws.datasync.model.ReportResult] =
      Optional.Absent,
    estimatedFilesToDelete: Optional[Long] = Optional.Absent,
    taskMode: Optional[zio.aws.datasync.model.TaskMode] = Optional.Absent,
    filesPrepared: Optional[Long] = Optional.Absent,
    filesListed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesListedDetail
    ] = Optional.Absent,
    filesFailed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesFailedDetail
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse = {
    import DescribeTaskExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
      .builder()
      .optionallyWith(
        taskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.taskExecutionArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(manifestConfig.map(value => value.buildAwsValue()))(
        _.manifestConfig
      )
      .optionallyWith(startTime.map(value => Time.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(
        estimatedFilesToTransfer.map(value => value: java.lang.Long)
      )(_.estimatedFilesToTransfer)
      .optionallyWith(
        estimatedBytesToTransfer.map(value => value: java.lang.Long)
      )(_.estimatedBytesToTransfer)
      .optionallyWith(filesTransferred.map(value => value: java.lang.Long))(
        _.filesTransferred
      )
      .optionallyWith(bytesWritten.map(value => value: java.lang.Long))(
        _.bytesWritten
      )
      .optionallyWith(bytesTransferred.map(value => value: java.lang.Long))(
        _.bytesTransferred
      )
      .optionallyWith(bytesCompressed.map(value => value: java.lang.Long))(
        _.bytesCompressed
      )
      .optionallyWith(result.map(value => value.buildAwsValue()))(_.result)
      .optionallyWith(taskReportConfig.map(value => value.buildAwsValue()))(
        _.taskReportConfig
      )
      .optionallyWith(filesDeleted.map(value => value: java.lang.Long))(
        _.filesDeleted
      )
      .optionallyWith(filesSkipped.map(value => value: java.lang.Long))(
        _.filesSkipped
      )
      .optionallyWith(filesVerified.map(value => value: java.lang.Long))(
        _.filesVerified
      )
      .optionallyWith(reportResult.map(value => value.buildAwsValue()))(
        _.reportResult
      )
      .optionallyWith(
        estimatedFilesToDelete.map(value => value: java.lang.Long)
      )(_.estimatedFilesToDelete)
      .optionallyWith(taskMode.map(value => value.unwrap))(_.taskMode)
      .optionallyWith(filesPrepared.map(value => value: java.lang.Long))(
        _.filesPrepared
      )
      .optionallyWith(filesListed.map(value => value.buildAwsValue()))(
        _.filesListed
      )
      .optionallyWith(filesFailed.map(value => value.buildAwsValue()))(
        _.filesFailed
      )
      .build()
  }
  def asReadOnly
      : zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly =
    zio.aws.datasync.model.DescribeTaskExecutionResponse.wrap(buildAwsValue())
}
object DescribeTaskExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskExecutionResponse =
      zio.aws.datasync.model.DescribeTaskExecutionResponse(
        taskExecutionArn.map(value => value),
        status.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        manifestConfig.map(value => value.asEditable),
        startTime.map(value => value),
        estimatedFilesToTransfer.map(value => value),
        estimatedBytesToTransfer.map(value => value),
        filesTransferred.map(value => value),
        bytesWritten.map(value => value),
        bytesTransferred.map(value => value),
        bytesCompressed.map(value => value),
        result.map(value => value.asEditable),
        taskReportConfig.map(value => value.asEditable),
        filesDeleted.map(value => value),
        filesSkipped.map(value => value),
        filesVerified.map(value => value),
        reportResult.map(value => value.asEditable),
        estimatedFilesToDelete.map(value => value),
        taskMode.map(value => value),
        filesPrepared.map(value => value),
        filesListed.map(value => value.asEditable),
        filesFailed.map(value => value.asEditable)
      )
    def taskExecutionArn: Optional[TaskExecutionArn]
    def status: Optional[zio.aws.datasync.model.TaskExecutionStatus]
    def options: Optional[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def includes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def manifestConfig: Optional[zio.aws.datasync.model.ManifestConfig.ReadOnly]
    def startTime: Optional[Time]
    def estimatedFilesToTransfer: Optional[Long]
    def estimatedBytesToTransfer: Optional[Long]
    def filesTransferred: Optional[Long]
    def bytesWritten: Optional[Long]
    def bytesTransferred: Optional[Long]
    def bytesCompressed: Optional[Long]
    def result
        : Optional[zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly]
    def taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly]
    def filesDeleted: Optional[Long]
    def filesSkipped: Optional[Long]
    def filesVerified: Optional[Long]
    def reportResult: Optional[zio.aws.datasync.model.ReportResult.ReadOnly]
    def estimatedFilesToDelete: Optional[Long]
    def taskMode: Optional[zio.aws.datasync.model.TaskMode]
    def filesPrepared: Optional[Long]
    def filesListed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly
    ]
    def filesFailed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly
    ]
    def getTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField("taskExecutionArn", taskExecutionArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskExecutionStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
    def getManifestConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.ManifestConfig.ReadOnly] =
      AwsError.unwrapOptionField("manifestConfig", manifestConfig)
    def getStartTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEstimatedFilesToTransfer: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("estimatedFilesToTransfer", estimatedFilesToTransfer)
    def getEstimatedBytesToTransfer: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("estimatedBytesToTransfer", estimatedBytesToTransfer)
    def getFilesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesTransferred", filesTransferred)
    def getBytesWritten: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesWritten", bytesWritten)
    def getBytesTransferred: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesTransferred", bytesTransferred)
    def getBytesCompressed: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("bytesCompressed", bytesCompressed)
    def getResult: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly
    ] = AwsError.unwrapOptionField("result", result)
    def getTaskReportConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      AwsError.unwrapOptionField("taskReportConfig", taskReportConfig)
    def getFilesDeleted: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesDeleted", filesDeleted)
    def getFilesSkipped: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesSkipped", filesSkipped)
    def getFilesVerified: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesVerified", filesVerified)
    def getReportResult
        : ZIO[Any, AwsError, zio.aws.datasync.model.ReportResult.ReadOnly] =
      AwsError.unwrapOptionField("reportResult", reportResult)
    def getEstimatedFilesToDelete: ZIO[Any, AwsError, Long] = AwsError
      .unwrapOptionField("estimatedFilesToDelete", estimatedFilesToDelete)
    def getTaskMode: ZIO[Any, AwsError, zio.aws.datasync.model.TaskMode] =
      AwsError.unwrapOptionField("taskMode", taskMode)
    def getFilesPrepared: ZIO[Any, AwsError, Long] =
      AwsError.unwrapOptionField("filesPrepared", filesPrepared)
    def getFilesListed: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly
    ] = AwsError.unwrapOptionField("filesListed", filesListed)
    def getFilesFailed: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly
    ] = AwsError.unwrapOptionField("filesFailed", filesFailed)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ) extends zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly {
    override val taskExecutionArn: Optional[TaskExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskExecutionArn())
        .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val status: Optional[zio.aws.datasync.model.TaskExecutionStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.TaskExecutionStatus.wrap(value))
    override val options: Optional[zio.aws.datasync.model.Options.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val includes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val manifestConfig
        : Optional[zio.aws.datasync.model.ManifestConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestConfig())
        .map(value => zio.aws.datasync.model.ManifestConfig.wrap(value))
    override val startTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val estimatedFilesToTransfer: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedFilesToTransfer())
        .map(value => value: Long)
    override val estimatedBytesToTransfer: Optional[Long] =
      zio.aws.core.internal
        .optionalFromNullable(impl.estimatedBytesToTransfer())
        .map(value => value: Long)
    override val filesTransferred: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.filesTransferred())
      .map(value => value: Long)
    override val bytesWritten: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesWritten())
      .map(value => value: Long)
    override val bytesTransferred: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesTransferred())
      .map(value => value: Long)
    override val bytesCompressed: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.bytesCompressed())
      .map(value => value: Long)
    override val result
        : Optional[zio.aws.datasync.model.TaskExecutionResultDetail.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.result())
        .map(value =>
          zio.aws.datasync.model.TaskExecutionResultDetail.wrap(value)
        )
    override val taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskReportConfig())
        .map(value => zio.aws.datasync.model.TaskReportConfig.wrap(value))
    override val filesDeleted: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.filesDeleted())
      .map(value => value: Long)
    override val filesSkipped: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.filesSkipped())
      .map(value => value: Long)
    override val filesVerified: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.filesVerified())
      .map(value => value: Long)
    override val reportResult
        : Optional[zio.aws.datasync.model.ReportResult.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.reportResult())
        .map(value => zio.aws.datasync.model.ReportResult.wrap(value))
    override val estimatedFilesToDelete: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.estimatedFilesToDelete())
      .map(value => value: Long)
    override val taskMode: Optional[zio.aws.datasync.model.TaskMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskMode())
        .map(value => zio.aws.datasync.model.TaskMode.wrap(value))
    override val filesPrepared: Optional[Long] = zio.aws.core.internal
      .optionalFromNullable(impl.filesPrepared())
      .map(value => value: Long)
    override val filesListed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesListedDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filesListed())
      .map(value =>
        zio.aws.datasync.model.TaskExecutionFilesListedDetail.wrap(value)
      )
    override val filesFailed: Optional[
      zio.aws.datasync.model.TaskExecutionFilesFailedDetail.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.filesFailed())
      .map(value =>
        zio.aws.datasync.model.TaskExecutionFilesFailedDetail.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskExecutionResponse
  ): zio.aws.datasync.model.DescribeTaskExecutionResponse.ReadOnly =
    new Wrapper(impl)
}
