package zio.aws.datasync.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{
  Time,
  TaskExecutionArn,
  LocationArn,
  TagValue,
  TaskArn,
  LogGroupArn,
  NetworkInterfaceArn
}
import scala.jdk.CollectionConverters._
final case class DescribeTaskResponse(
    taskArn: Optional[TaskArn] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.TaskStatus] = Optional.Absent,
    name: Optional[TagValue] = Optional.Absent,
    currentTaskExecutionArn: Optional[TaskExecutionArn] = Optional.Absent,
    sourceLocationArn: Optional[LocationArn] = Optional.Absent,
    destinationLocationArn: Optional[LocationArn] = Optional.Absent,
    cloudWatchLogGroupArn: Optional[LogGroupArn] = Optional.Absent,
    sourceNetworkInterfaceArns: Optional[Iterable[NetworkInterfaceArn]] =
      Optional.Absent,
    destinationNetworkInterfaceArns: Optional[Iterable[NetworkInterfaceArn]] =
      Optional.Absent,
    options: Optional[zio.aws.datasync.model.Options] = Optional.Absent,
    excludes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    schedule: Optional[zio.aws.datasync.model.TaskSchedule] = Optional.Absent,
    errorCode: Optional[String] = Optional.Absent,
    errorDetail: Optional[String] = Optional.Absent,
    creationTime: Optional[Time] = Optional.Absent,
    includes: Optional[Iterable[zio.aws.datasync.model.FilterRule]] =
      Optional.Absent,
    manifestConfig: Optional[zio.aws.datasync.model.ManifestConfig] =
      Optional.Absent,
    taskReportConfig: Optional[zio.aws.datasync.model.TaskReportConfig] =
      Optional.Absent,
    scheduleDetails: Optional[zio.aws.datasync.model.TaskScheduleDetails] =
      Optional.Absent,
    taskMode: Optional[zio.aws.datasync.model.TaskMode] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DescribeTaskResponse = {
    import DescribeTaskResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
      .builder()
      .optionallyWith(
        taskArn.map(value => TaskArn.unwrap(value): java.lang.String)
      )(_.taskArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        name.map(value => TagValue.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        currentTaskExecutionArn.map(value =>
          TaskExecutionArn.unwrap(value): java.lang.String
        )
      )(_.currentTaskExecutionArn)
      .optionallyWith(
        sourceLocationArn.map(value =>
          LocationArn.unwrap(value): java.lang.String
        )
      )(_.sourceLocationArn)
      .optionallyWith(
        destinationLocationArn.map(value =>
          LocationArn.unwrap(value): java.lang.String
        )
      )(_.destinationLocationArn)
      .optionallyWith(
        cloudWatchLogGroupArn.map(value =>
          LogGroupArn.unwrap(value): java.lang.String
        )
      )(_.cloudWatchLogGroupArn)
      .optionallyWith(
        sourceNetworkInterfaceArns.map(value =>
          value.map { item =>
            NetworkInterfaceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.sourceNetworkInterfaceArns)
      .optionallyWith(
        destinationNetworkInterfaceArns.map(value =>
          value.map { item =>
            NetworkInterfaceArn.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.destinationNetworkInterfaceArns)
      .optionallyWith(options.map(value => value.buildAwsValue()))(_.options)
      .optionallyWith(
        excludes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludes)
      .optionallyWith(schedule.map(value => value.buildAwsValue()))(_.schedule)
      .optionallyWith(errorCode.map(value => value: java.lang.String))(
        _.errorCode
      )
      .optionallyWith(errorDetail.map(value => value: java.lang.String))(
        _.errorDetail
      )
      .optionallyWith(creationTime.map(value => Time.unwrap(value): Instant))(
        _.creationTime
      )
      .optionallyWith(
        includes.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.includes)
      .optionallyWith(manifestConfig.map(value => value.buildAwsValue()))(
        _.manifestConfig
      )
      .optionallyWith(taskReportConfig.map(value => value.buildAwsValue()))(
        _.taskReportConfig
      )
      .optionallyWith(scheduleDetails.map(value => value.buildAwsValue()))(
        _.scheduleDetails
      )
      .optionallyWith(taskMode.map(value => value.unwrap))(_.taskMode)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DescribeTaskResponse.ReadOnly =
    zio.aws.datasync.model.DescribeTaskResponse.wrap(buildAwsValue())
}
object DescribeTaskResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DescribeTaskResponse =
      zio.aws.datasync.model.DescribeTaskResponse(
        taskArn.map(value => value),
        status.map(value => value),
        name.map(value => value),
        currentTaskExecutionArn.map(value => value),
        sourceLocationArn.map(value => value),
        destinationLocationArn.map(value => value),
        cloudWatchLogGroupArn.map(value => value),
        sourceNetworkInterfaceArns.map(value => value),
        destinationNetworkInterfaceArns.map(value => value),
        options.map(value => value.asEditable),
        excludes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedule.map(value => value.asEditable),
        errorCode.map(value => value),
        errorDetail.map(value => value),
        creationTime.map(value => value),
        includes.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        manifestConfig.map(value => value.asEditable),
        taskReportConfig.map(value => value.asEditable),
        scheduleDetails.map(value => value.asEditable),
        taskMode.map(value => value)
      )
    def taskArn: Optional[TaskArn]
    def status: Optional[zio.aws.datasync.model.TaskStatus]
    def name: Optional[TagValue]
    def currentTaskExecutionArn: Optional[TaskExecutionArn]
    def sourceLocationArn: Optional[LocationArn]
    def destinationLocationArn: Optional[LocationArn]
    def cloudWatchLogGroupArn: Optional[LogGroupArn]
    def sourceNetworkInterfaceArns: Optional[List[NetworkInterfaceArn]]
    def destinationNetworkInterfaceArns: Optional[List[NetworkInterfaceArn]]
    def options: Optional[zio.aws.datasync.model.Options.ReadOnly]
    def excludes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def schedule: Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly]
    def errorCode: Optional[String]
    def errorDetail: Optional[String]
    def creationTime: Optional[Time]
    def includes: Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]]
    def manifestConfig: Optional[zio.aws.datasync.model.ManifestConfig.ReadOnly]
    def taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly]
    def scheduleDetails
        : Optional[zio.aws.datasync.model.TaskScheduleDetails.ReadOnly]
    def taskMode: Optional[zio.aws.datasync.model.TaskMode]
    def getTaskArn: ZIO[Any, AwsError, TaskArn] =
      AwsError.unwrapOptionField("taskArn", taskArn)
    def getStatus: ZIO[Any, AwsError, zio.aws.datasync.model.TaskStatus] =
      AwsError.unwrapOptionField("status", status)
    def getName: ZIO[Any, AwsError, TagValue] =
      AwsError.unwrapOptionField("name", name)
    def getCurrentTaskExecutionArn: ZIO[Any, AwsError, TaskExecutionArn] =
      AwsError.unwrapOptionField(
        "currentTaskExecutionArn",
        currentTaskExecutionArn
      )
    def getSourceLocationArn: ZIO[Any, AwsError, LocationArn] =
      AwsError.unwrapOptionField("sourceLocationArn", sourceLocationArn)
    def getDestinationLocationArn: ZIO[Any, AwsError, LocationArn] = AwsError
      .unwrapOptionField("destinationLocationArn", destinationLocationArn)
    def getCloudWatchLogGroupArn: ZIO[Any, AwsError, LogGroupArn] =
      AwsError.unwrapOptionField("cloudWatchLogGroupArn", cloudWatchLogGroupArn)
    def getSourceNetworkInterfaceArns
        : ZIO[Any, AwsError, List[NetworkInterfaceArn]] =
      AwsError.unwrapOptionField(
        "sourceNetworkInterfaceArns",
        sourceNetworkInterfaceArns
      )
    def getDestinationNetworkInterfaceArns
        : ZIO[Any, AwsError, List[NetworkInterfaceArn]] =
      AwsError.unwrapOptionField(
        "destinationNetworkInterfaceArns",
        destinationNetworkInterfaceArns
      )
    def getOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.Options.ReadOnly] =
      AwsError.unwrapOptionField("options", options)
    def getExcludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("excludes", excludes)
    def getSchedule
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      AwsError.unwrapOptionField("schedule", schedule)
    def getErrorCode: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorCode", errorCode)
    def getErrorDetail: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("errorDetail", errorDetail)
    def getCreationTime: ZIO[Any, AwsError, Time] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getIncludes
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      AwsError.unwrapOptionField("includes", includes)
    def getManifestConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.ManifestConfig.ReadOnly] =
      AwsError.unwrapOptionField("manifestConfig", manifestConfig)
    def getTaskReportConfig
        : ZIO[Any, AwsError, zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      AwsError.unwrapOptionField("taskReportConfig", taskReportConfig)
    def getScheduleDetails: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.TaskScheduleDetails.ReadOnly
    ] = AwsError.unwrapOptionField("scheduleDetails", scheduleDetails)
    def getTaskMode: ZIO[Any, AwsError, zio.aws.datasync.model.TaskMode] =
      AwsError.unwrapOptionField("taskMode", taskMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ) extends zio.aws.datasync.model.DescribeTaskResponse.ReadOnly {
    override val taskArn: Optional[TaskArn] = zio.aws.core.internal
      .optionalFromNullable(impl.taskArn())
      .map(value => zio.aws.datasync.model.primitives.TaskArn(value))
    override val status: Optional[zio.aws.datasync.model.TaskStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.TaskStatus.wrap(value))
    override val name: Optional[TagValue] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.datasync.model.primitives.TagValue(value))
    override val currentTaskExecutionArn: Optional[TaskExecutionArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.currentTaskExecutionArn())
        .map(value => zio.aws.datasync.model.primitives.TaskExecutionArn(value))
    override val sourceLocationArn: Optional[LocationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sourceLocationArn())
        .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val destinationLocationArn: Optional[LocationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationLocationArn())
        .map(value => zio.aws.datasync.model.primitives.LocationArn(value))
    override val cloudWatchLogGroupArn: Optional[LogGroupArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cloudWatchLogGroupArn())
        .map(value => zio.aws.datasync.model.primitives.LogGroupArn(value))
    override val sourceNetworkInterfaceArns
        : Optional[List[NetworkInterfaceArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.sourceNetworkInterfaceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.NetworkInterfaceArn(item)
        }.toList
      )
    override val destinationNetworkInterfaceArns
        : Optional[List[NetworkInterfaceArn]] = zio.aws.core.internal
      .optionalFromNullable(impl.destinationNetworkInterfaceArns())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.primitives.NetworkInterfaceArn(item)
        }.toList
      )
    override val options: Optional[zio.aws.datasync.model.Options.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.options())
        .map(value => zio.aws.datasync.model.Options.wrap(value))
    override val excludes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val schedule
        : Optional[zio.aws.datasync.model.TaskSchedule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedule())
        .map(value => zio.aws.datasync.model.TaskSchedule.wrap(value))
    override val errorCode: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorCode())
      .map(value => value: String)
    override val errorDetail: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.errorDetail())
      .map(value => value: String)
    override val creationTime: Optional[Time] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.datasync.model.primitives.Time(value))
    override val includes
        : Optional[List[zio.aws.datasync.model.FilterRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.FilterRule.wrap(item)
          }.toList
        )
    override val manifestConfig
        : Optional[zio.aws.datasync.model.ManifestConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.manifestConfig())
        .map(value => zio.aws.datasync.model.ManifestConfig.wrap(value))
    override val taskReportConfig
        : Optional[zio.aws.datasync.model.TaskReportConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskReportConfig())
        .map(value => zio.aws.datasync.model.TaskReportConfig.wrap(value))
    override val scheduleDetails
        : Optional[zio.aws.datasync.model.TaskScheduleDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scheduleDetails())
        .map(value => zio.aws.datasync.model.TaskScheduleDetails.wrap(value))
    override val taskMode: Optional[zio.aws.datasync.model.TaskMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.taskMode())
        .map(value => zio.aws.datasync.model.TaskMode.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DescribeTaskResponse
  ): zio.aws.datasync.model.DescribeTaskResponse.ReadOnly = new Wrapper(impl)
}
