package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryJobArn
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DiscoveryJobListEntry(
    discoveryJobArn: Optional[DiscoveryJobArn] = Optional.Absent,
    status: Optional[zio.aws.datasync.model.DiscoveryJobStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry = {
    import DiscoveryJobListEntry.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry
      .builder()
      .optionallyWith(
        discoveryJobArn.map(value =>
          DiscoveryJobArn.unwrap(value): java.lang.String
        )
      )(_.discoveryJobArn)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly =
    zio.aws.datasync.model.DiscoveryJobListEntry.wrap(buildAwsValue())
}
object DiscoveryJobListEntry {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.DiscoveryJobListEntry =
      zio.aws.datasync.model.DiscoveryJobListEntry(
        discoveryJobArn.map(value => value),
        status.map(value => value)
      )
    def discoveryJobArn: Optional[DiscoveryJobArn]
    def status: Optional[zio.aws.datasync.model.DiscoveryJobStatus]
    def getDiscoveryJobArn: ZIO[Any, AwsError, DiscoveryJobArn] =
      AwsError.unwrapOptionField("discoveryJobArn", discoveryJobArn)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.datasync.model.DiscoveryJobStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry
  ) extends zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly {
    override val discoveryJobArn: Optional[DiscoveryJobArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.discoveryJobArn())
        .map(value => zio.aws.datasync.model.primitives.DiscoveryJobArn(value))
    override val status: Optional[zio.aws.datasync.model.DiscoveryJobStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.datasync.model.DiscoveryJobStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.DiscoveryJobListEntry
  ): zio.aws.datasync.model.DiscoveryJobListEntry.ReadOnly = new Wrapper(impl)
}
