package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait DiscoveryJobStatus {
  def unwrap: software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus
}
object DiscoveryJobStatus {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus
  ): zio.aws.datasync.model.DiscoveryJobStatus = value match {
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.RUNNING =>
      val r = RUNNING
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.WARNING =>
      val r = WARNING
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.TERMINATED =>
      val r = TERMINATED
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.STOPPED =>
      val r = STOPPED
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.COMPLETED_WITH_ISSUES =>
      val r = COMPLETED_WITH_ISSUES
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object RUNNING extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.RUNNING
  }
  case object WARNING extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.WARNING
  }
  case object TERMINATED extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.TERMINATED
  }
  case object FAILED extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.FAILED
  }
  case object STOPPED extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.STOPPED
  }
  case object COMPLETED extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.COMPLETED
  }
  case object COMPLETED_WITH_ISSUES
      extends zio.aws.datasync.model.DiscoveryJobStatus {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus =
      software.amazon.awssdk.services.datasync.model.DiscoveryJobStatus.COMPLETED_WITH_ISSUES
  }
}
