package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FsxUpdateProtocol(
    nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs] = Optional.Absent,
    smb: Optional[zio.aws.datasync.model.FsxUpdateProtocolSmb] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol = {
    import FsxUpdateProtocol.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol
      .builder()
      .optionallyWith(nfs.map(value => value.buildAwsValue()))(_.nfs)
      .optionallyWith(smb.map(value => value.buildAwsValue()))(_.smb)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly =
    zio.aws.datasync.model.FsxUpdateProtocol.wrap(buildAwsValue())
}
object FsxUpdateProtocol {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FsxUpdateProtocol =
      zio.aws.datasync.model.FsxUpdateProtocol(
        nfs.map(value => value.asEditable),
        smb.map(value => value.asEditable)
      )
    def nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs.ReadOnly]
    def smb: Optional[zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly]
    def getNfs
        : ZIO[Any, AwsError, zio.aws.datasync.model.FsxProtocolNfs.ReadOnly] =
      AwsError.unwrapOptionField("nfs", nfs)
    def getSmb: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly
    ] = AwsError.unwrapOptionField("smb", smb)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol
  ) extends zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly {
    override val nfs: Optional[zio.aws.datasync.model.FsxProtocolNfs.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.nfs())
        .map(value => zio.aws.datasync.model.FsxProtocolNfs.wrap(value))
    override val smb
        : Optional[zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.smb())
        .map(value => zio.aws.datasync.model.FsxUpdateProtocolSmb.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FsxUpdateProtocol
  ): zio.aws.datasync.model.FsxUpdateProtocol.ReadOnly = new Wrapper(impl)
}
