package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.{SmbUser, SmbPassword, UpdateSmbDomain}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class FsxUpdateProtocolSmb(
    domain: Optional[UpdateSmbDomain] = Optional.Absent,
    mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions] =
      Optional.Absent,
    password: Optional[SmbPassword] = Optional.Absent,
    user: Optional[SmbUser] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb = {
    import FsxUpdateProtocolSmb.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb
      .builder()
      .optionallyWith(
        domain.map(value => UpdateSmbDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(mountOptions.map(value => value.buildAwsValue()))(
        _.mountOptions
      )
      .optionallyWith(
        password.map(value => SmbPassword.unwrap(value): java.lang.String)
      )(_.password)
      .optionallyWith(
        user.map(value => SmbUser.unwrap(value): java.lang.String)
      )(_.user)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly =
    zio.aws.datasync.model.FsxUpdateProtocolSmb.wrap(buildAwsValue())
}
object FsxUpdateProtocolSmb {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.FsxUpdateProtocolSmb =
      zio.aws.datasync.model.FsxUpdateProtocolSmb(
        domain.map(value => value),
        mountOptions.map(value => value.asEditable),
        password.map(value => value),
        user.map(value => value)
      )
    def domain: Optional[UpdateSmbDomain]
    def mountOptions: Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly]
    def password: Optional[SmbPassword]
    def user: Optional[SmbUser]
    def getDomain: ZIO[Any, AwsError, UpdateSmbDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getMountOptions
        : ZIO[Any, AwsError, zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      AwsError.unwrapOptionField("mountOptions", mountOptions)
    def getPassword: ZIO[Any, AwsError, SmbPassword] =
      AwsError.unwrapOptionField("password", password)
    def getUser: ZIO[Any, AwsError, SmbUser] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb
  ) extends zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly {
    override val domain: Optional[UpdateSmbDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.datasync.model.primitives.UpdateSmbDomain(value))
    override val mountOptions
        : Optional[zio.aws.datasync.model.SmbMountOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.mountOptions())
        .map(value => zio.aws.datasync.model.SmbMountOptions.wrap(value))
    override val password: Optional[SmbPassword] = zio.aws.core.internal
      .optionalFromNullable(impl.password())
      .map(value => zio.aws.datasync.model.primitives.SmbPassword(value))
    override val user: Optional[SmbUser] = zio.aws.core.internal
      .optionalFromNullable(impl.user())
      .map(value => zio.aws.datasync.model.primitives.SmbUser(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.FsxUpdateProtocolSmb
  ): zio.aws.datasync.model.FsxUpdateProtocolSmb.ReadOnly = new Wrapper(impl)
}
