package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.NonNegativeDouble
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class IOPS(
    read: Optional[NonNegativeDouble] = Optional.Absent,
    write: Optional[NonNegativeDouble] = Optional.Absent,
    other: Optional[NonNegativeDouble] = Optional.Absent,
    total: Optional[NonNegativeDouble] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.datasync.model.IOPS = {
    import IOPS.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.IOPS
      .builder()
      .optionallyWith(
        read.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.read)
      .optionallyWith(
        write.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.write)
      .optionallyWith(
        other.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.other)
      .optionallyWith(
        total.map(value => NonNegativeDouble.unwrap(value): java.lang.Double)
      )(_.total)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.IOPS.ReadOnly =
    zio.aws.datasync.model.IOPS.wrap(buildAwsValue())
}
object IOPS {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.datasync.model.IOPS] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.IOPS = zio.aws.datasync.model.IOPS(
      read.map(value => value),
      write.map(value => value),
      other.map(value => value),
      total.map(value => value)
    )
    def read: Optional[NonNegativeDouble]
    def write: Optional[NonNegativeDouble]
    def other: Optional[NonNegativeDouble]
    def total: Optional[NonNegativeDouble]
    def getRead: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("read", read)
    def getWrite: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("write", write)
    def getOther: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("other", other)
    def getTotal: ZIO[Any, AwsError, NonNegativeDouble] =
      AwsError.unwrapOptionField("total", total)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.IOPS
  ) extends zio.aws.datasync.model.IOPS.ReadOnly {
    override val read: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.read())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val write: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.write())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val other: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.other())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
    override val total: Optional[NonNegativeDouble] = zio.aws.core.internal
      .optionalFromNullable(impl.total())
      .map(value => zio.aws.datasync.model.primitives.NonNegativeDouble(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.IOPS
  ): zio.aws.datasync.model.IOPS.ReadOnly = new Wrapper(impl)
}
