package zio.aws.datasync.model
import zio.aws.datasync.model.primitives.DiscoveryNextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListStorageSystemsResponse(
    storageSystems: Optional[
      Iterable[zio.aws.datasync.model.StorageSystemListEntry]
    ] = Optional.Absent,
    nextToken: Optional[DiscoveryNextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse = {
    import ListStorageSystemsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse
      .builder()
      .optionallyWith(
        storageSystems.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.storageSystems)
      .optionallyWith(
        nextToken.map(value =>
          DiscoveryNextToken.unwrap(value): java.lang.String
        )
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly =
    zio.aws.datasync.model.ListStorageSystemsResponse.wrap(buildAwsValue())
}
object ListStorageSystemsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListStorageSystemsResponse =
      zio.aws.datasync.model.ListStorageSystemsResponse(
        storageSystems.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def storageSystems
        : Optional[List[zio.aws.datasync.model.StorageSystemListEntry.ReadOnly]]
    def nextToken: Optional[DiscoveryNextToken]
    def getStorageSystems: ZIO[Any, AwsError, List[
      zio.aws.datasync.model.StorageSystemListEntry.ReadOnly
    ]] = AwsError.unwrapOptionField("storageSystems", storageSystems)
    def getNextToken: ZIO[Any, AwsError, DiscoveryNextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse
  ) extends zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly {
    override val storageSystems: Optional[
      List[zio.aws.datasync.model.StorageSystemListEntry.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.storageSystems())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.datasync.model.StorageSystemListEntry.wrap(item)
        }.toList
      )
    override val nextToken: Optional[DiscoveryNextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.DiscoveryNextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListStorageSystemsResponse
  ): zio.aws.datasync.model.ListStorageSystemsResponse.ReadOnly = new Wrapper(
    impl
  )
}
