package zio.aws.datasync.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.datasync.model.primitives.{NextToken, MaxResults}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListTasksRequest(
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    filters: Optional[Iterable[zio.aws.datasync.model.TaskFilter]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ListTasksRequest = {
    import ListTasksRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ListTasksRequest
      .builder()
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ListTasksRequest.ReadOnly =
    zio.aws.datasync.model.ListTasksRequest.wrap(buildAwsValue())
}
object ListTasksRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ListTasksRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ListTasksRequest =
      zio.aws.datasync.model.ListTasksRequest(
        maxResults.map(value => value),
        nextToken.map(value => value),
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def filters: Optional[List[zio.aws.datasync.model.TaskFilter.ReadOnly]]
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.datasync.model.TaskFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ListTasksRequest
  ) extends zio.aws.datasync.model.ListTasksRequest.ReadOnly {
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.datasync.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.datasync.model.primitives.NextToken(value))
    override val filters
        : Optional[List[zio.aws.datasync.model.TaskFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.datasync.model.TaskFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ListTasksRequest
  ): zio.aws.datasync.model.ListTasksRequest.ReadOnly = new Wrapper(impl)
}
