package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait LocationFilterName {
  def unwrap: software.amazon.awssdk.services.datasync.model.LocationFilterName
}
object LocationFilterName {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.LocationFilterName
  ): zio.aws.datasync.model.LocationFilterName = value match {
    case software.amazon.awssdk.services.datasync.model.LocationFilterName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.LocationFilterName.LOCATION_URI =>
      val r = LocationUri
      r
    case software.amazon.awssdk.services.datasync.model.LocationFilterName.LOCATION_TYPE =>
      val r = LocationType
      r
    case software.amazon.awssdk.services.datasync.model.LocationFilterName.CREATION_TIME =>
      val r = CreationTime
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.LocationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LocationFilterName =
      software.amazon.awssdk.services.datasync.model.LocationFilterName.UNKNOWN_TO_SDK_VERSION
  }
  case object LocationUri extends zio.aws.datasync.model.LocationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LocationFilterName =
      software.amazon.awssdk.services.datasync.model.LocationFilterName.LOCATION_URI
  }
  case object LocationType extends zio.aws.datasync.model.LocationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LocationFilterName =
      software.amazon.awssdk.services.datasync.model.LocationFilterName.LOCATION_TYPE
  }
  case object CreationTime extends zio.aws.datasync.model.LocationFilterName {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.LocationFilterName =
      software.amazon.awssdk.services.datasync.model.LocationFilterName.CREATION_TIME
  }
}
