package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait ManifestAction {
  def unwrap: software.amazon.awssdk.services.datasync.model.ManifestAction
}
object ManifestAction {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ManifestAction
  ): zio.aws.datasync.model.ManifestAction = value match {
    case software.amazon.awssdk.services.datasync.model.ManifestAction.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ManifestAction.TRANSFER =>
      val r = TRANSFER
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ManifestAction {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ManifestAction =
      software.amazon.awssdk.services.datasync.model.ManifestAction.UNKNOWN_TO_SDK_VERSION
  }
  case object TRANSFER extends zio.aws.datasync.model.ManifestAction {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ManifestAction =
      software.amazon.awssdk.services.datasync.model.ManifestAction.TRANSFER
  }
}
