package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ManifestConfig(
    action: Optional[zio.aws.datasync.model.ManifestAction] = Optional.Absent,
    format: Optional[zio.aws.datasync.model.ManifestFormat] = Optional.Absent,
    source: Optional[zio.aws.datasync.model.SourceManifestConfig] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.ManifestConfig = {
    import ManifestConfig.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.ManifestConfig
      .builder()
      .optionallyWith(action.map(value => value.unwrap))(_.action)
      .optionallyWith(format.map(value => value.unwrap))(_.format)
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.ManifestConfig.ReadOnly =
    zio.aws.datasync.model.ManifestConfig.wrap(buildAwsValue())
}
object ManifestConfig {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.ManifestConfig
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.ManifestConfig =
      zio.aws.datasync.model.ManifestConfig(
        action.map(value => value),
        format.map(value => value),
        source.map(value => value.asEditable)
      )
    def action: Optional[zio.aws.datasync.model.ManifestAction]
    def format: Optional[zio.aws.datasync.model.ManifestFormat]
    def source: Optional[zio.aws.datasync.model.SourceManifestConfig.ReadOnly]
    def getAction: ZIO[Any, AwsError, zio.aws.datasync.model.ManifestAction] =
      AwsError.unwrapOptionField("action", action)
    def getFormat: ZIO[Any, AwsError, zio.aws.datasync.model.ManifestFormat] =
      AwsError.unwrapOptionField("format", format)
    def getSource: ZIO[
      Any,
      AwsError,
      zio.aws.datasync.model.SourceManifestConfig.ReadOnly
    ] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.ManifestConfig
  ) extends zio.aws.datasync.model.ManifestConfig.ReadOnly {
    override val action: Optional[zio.aws.datasync.model.ManifestAction] =
      zio.aws.core.internal
        .optionalFromNullable(impl.action())
        .map(value => zio.aws.datasync.model.ManifestAction.wrap(value))
    override val format: Optional[zio.aws.datasync.model.ManifestFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.format())
        .map(value => zio.aws.datasync.model.ManifestFormat.wrap(value))
    override val source
        : Optional[zio.aws.datasync.model.SourceManifestConfig.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.datasync.model.SourceManifestConfig.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.ManifestConfig
  ): zio.aws.datasync.model.ManifestConfig.ReadOnly = new Wrapper(impl)
}
