package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait ManifestFormat {
  def unwrap: software.amazon.awssdk.services.datasync.model.ManifestFormat
}
object ManifestFormat {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ManifestFormat
  ): zio.aws.datasync.model.ManifestFormat = value match {
    case software.amazon.awssdk.services.datasync.model.ManifestFormat.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ManifestFormat.CSV =>
      val r = CSV
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ManifestFormat =
      software.amazon.awssdk.services.datasync.model.ManifestFormat.UNKNOWN_TO_SDK_VERSION
  }
  case object CSV extends zio.aws.datasync.model.ManifestFormat {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ManifestFormat =
      software.amazon.awssdk.services.datasync.model.ManifestFormat.CSV
  }
}
