package zio.aws.datasync.model
import scala.jdk.CollectionConverters._
sealed trait ObjectStorageServerProtocol {
  def unwrap: software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol
}
object ObjectStorageServerProtocol {
  def wrap(
      value: software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol
  ): zio.aws.datasync.model.ObjectStorageServerProtocol = value match {
    case software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.HTTPS =>
      val r = HTTPS
      r
    case software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.HTTP =>
      val r = HTTP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.datasync.model.ObjectStorageServerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol =
      software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.UNKNOWN_TO_SDK_VERSION
  }
  case object HTTPS extends zio.aws.datasync.model.ObjectStorageServerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol =
      software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.HTTPS
  }
  case object HTTP extends zio.aws.datasync.model.ObjectStorageServerProtocol {
    override def unwrap
        : software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol =
      software.amazon.awssdk.services.datasync.model.ObjectStorageServerProtocol.HTTP
  }
}
