package zio.aws.datasync.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class P95Metrics(
    iops: Optional[zio.aws.datasync.model.IOPS] = Optional.Absent,
    throughput: Optional[zio.aws.datasync.model.Throughput] = Optional.Absent,
    latency: Optional[zio.aws.datasync.model.Latency] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.datasync.model.P95Metrics = {
    import P95Metrics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.datasync.model.P95Metrics
      .builder()
      .optionallyWith(iops.map(value => value.buildAwsValue()))(_.iops)
      .optionallyWith(throughput.map(value => value.buildAwsValue()))(
        _.throughput
      )
      .optionallyWith(latency.map(value => value.buildAwsValue()))(_.latency)
      .build()
  }
  def asReadOnly: zio.aws.datasync.model.P95Metrics.ReadOnly =
    zio.aws.datasync.model.P95Metrics.wrap(buildAwsValue())
}
object P95Metrics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.datasync.model.P95Metrics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.datasync.model.P95Metrics =
      zio.aws.datasync.model.P95Metrics(
        iops.map(value => value.asEditable),
        throughput.map(value => value.asEditable),
        latency.map(value => value.asEditable)
      )
    def iops: Optional[zio.aws.datasync.model.IOPS.ReadOnly]
    def throughput: Optional[zio.aws.datasync.model.Throughput.ReadOnly]
    def latency: Optional[zio.aws.datasync.model.Latency.ReadOnly]
    def getIops: ZIO[Any, AwsError, zio.aws.datasync.model.IOPS.ReadOnly] =
      AwsError.unwrapOptionField("iops", iops)
    def getThroughput
        : ZIO[Any, AwsError, zio.aws.datasync.model.Throughput.ReadOnly] =
      AwsError.unwrapOptionField("throughput", throughput)
    def getLatency
        : ZIO[Any, AwsError, zio.aws.datasync.model.Latency.ReadOnly] =
      AwsError.unwrapOptionField("latency", latency)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.datasync.model.P95Metrics
  ) extends zio.aws.datasync.model.P95Metrics.ReadOnly {
    override val iops: Optional[zio.aws.datasync.model.IOPS.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.iops())
        .map(value => zio.aws.datasync.model.IOPS.wrap(value))
    override val throughput
        : Optional[zio.aws.datasync.model.Throughput.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.throughput())
        .map(value => zio.aws.datasync.model.Throughput.wrap(value))
    override val latency: Optional[zio.aws.datasync.model.Latency.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latency())
        .map(value => zio.aws.datasync.model.Latency.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.datasync.model.P95Metrics
  ): zio.aws.datasync.model.P95Metrics.ReadOnly = new Wrapper(impl)
}
